/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitExecutable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScriptGenerator {
    private final String myPrefix;
    private final Class myMainClass;
    private final ArrayList<File> myPaths;
    private final ArrayList<String> myInternalParameters;

    public ScriptGenerator(@NotNull @NonNls String prefix, @NotNull Class mainClass) {
        if (prefix == null) {
            ScriptGenerator.$$$reportNull$$$0(0);
        }
        if (mainClass == null) {
            ScriptGenerator.$$$reportNull$$$0(1);
        }
        this.myPaths = new ArrayList();
        this.myInternalParameters = new ArrayList();
        this.myPrefix = prefix;
        this.myMainClass = mainClass;
        this.addClasses(this.myMainClass);
        this.addClasses(XmlRpcClientLite.class, DecoderException.class);
    }

    private void addClasses(Class ... classes) {
        for (Class c : classes) {
            File classPath = new File(PathUtil.getJarPathForClass((Class)c));
            if (this.myPaths.contains(classPath)) continue;
            this.myPaths.add(classPath);
        }
    }

    public ScriptGenerator addInternal(String ... parameters) {
        ContainerUtil.addAll(this.myInternalParameters, (Object[])parameters);
        return this;
    }

    @NotNull
    private static File generateBatch(@NotNull @NonNls String fileName, @NotNull @NonNls String commandLine) throws IOException {
        if (fileName == null) {
            ScriptGenerator.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            ScriptGenerator.$$$reportNull$$$0(3);
        }
        @NonNls StringBuilder sb = new StringBuilder();
        sb.append("@echo off").append("\n");
        sb.append(commandLine).append(" %*").append("\n");
        return ScriptGenerator.createTempExecutable(fileName + ".bat", sb.toString());
    }

    @NotNull
    private static File generateShell(@NotNull @NonNls String fileName, @NotNull @NonNls String commandLine) throws IOException {
        if (fileName == null) {
            ScriptGenerator.$$$reportNull$$$0(4);
        }
        if (commandLine == null) {
            ScriptGenerator.$$$reportNull$$$0(5);
        }
        @NonNls StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/sh").append("\n");
        sb.append(commandLine).append(" \"$@\"").append("\n");
        return ScriptGenerator.createTempExecutable(fileName + ".sh", sb.toString());
    }

    @NotNull
    private static File createTempExecutable(@NotNull @NonNls String fileName, @NotNull @NonNls String content2) throws IOException {
        if (fileName == null) {
            ScriptGenerator.$$$reportNull$$$0(6);
        }
        if (content2 == null) {
            ScriptGenerator.$$$reportNull$$$0(7);
        }
        File file = new File(PathManager.getTempPath(), fileName);
        FileUtil.writeToFile((File)file, (String)content2);
        FileUtil.setExecutable((File)file);
        File file2 = file;
        if (file2 == null) {
            ScriptGenerator.$$$reportNull$$$0(8);
        }
        return file2;
    }

    @NotNull
    public File generate(@NotNull GitExecutable executable, boolean useBatchFile) throws IOException {
        if (executable == null) {
            ScriptGenerator.$$$reportNull$$$0(9);
        }
        String commandLine = this.commandLine(executable);
        return useBatchFile ? ScriptGenerator.generateBatch(this.myPrefix, commandLine) : ScriptGenerator.generateShell(this.myPrefix, commandLine);
    }

    @NonNls
    public String commandLine(@NotNull GitExecutable executable) {
        if (executable == null) {
            ScriptGenerator.$$$reportNull$$$0(10);
        }
        @NonNls StringBuilder cmd = new StringBuilder();
        if (executable instanceof GitExecutable.Wsl) {
            ArrayList envs = ContainerUtil.newArrayList((Object[])new String[]{"INTELLIJ_SSH_ASKPASS_HANDLER", "INTELLIJ_SSH_ASKPASS_PORT", "GIT_ASKPASS_HANDLER", "GIT_ASKPASS_PORT", "IDEA_REBASE_HANDER_NO"});
            cmd.append("export WSLENV=");
            cmd.append(StringUtil.join((Collection)envs, it -> it + "/w", (String)":"));
            cmd.append("\n");
            cmd.append('\"');
            File javaExecutable = new File(String.format("%s\\bin\\java.exe", System.getProperty("java.home")));
            cmd.append(executable.convertFilePath(javaExecutable));
            cmd.append('\"');
        } else {
            cmd.append('\"');
            cmd.append(String.format("%s/bin/java", System.getProperty("java.home")));
            cmd.append('\"');
        }
        cmd.append(" -cp ");
        cmd.append('\"');
        String classpathSeparator = String.valueOf(File.pathSeparatorChar);
        cmd.append(StringUtil.join(this.myPaths, file -> file.getPath(), (String)classpathSeparator));
        cmd.append('\"');
        cmd.append(' ');
        cmd.append(this.myMainClass.getName());
        for (String p : this.myInternalParameters) {
            cmd.append(' ');
            cmd.append(p);
        }
        String line = cmd.toString();
        if (SystemInfo.isWindows) {
            line = line.replace('\\', '/');
        }
        return line;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClass";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/ScriptGenerator";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/ScriptGenerator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateBatch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateShell";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTempExecutable";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "commandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

