/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import git4idea.GitIcons;
import git4idea.i18n.GitBundle;
import git4idea.log.GitCommitSignature;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006\u0006"}, d2={"getIcon", "Ljavax/swing/Icon;", "signature", "Lgit4idea/log/GitCommitSignature;", "getToolTip", "Lcom/intellij/openapi/util/text/HtmlChunk;", "intellij.vcs.git"})
public final class GitCommitSignatureLogCellRendererKt {
    private static final Icon getIcon(GitCommitSignature signature) {
        Icon icon;
        GitCommitSignature gitCommitSignature = signature;
        if (gitCommitSignature instanceof GitCommitSignature.Verified) {
            icon = GitIcons.Verified;
        } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NotVerified.INSTANCE)) {
            icon = GitIcons.Signed;
        } else if (gitCommitSignature == null || Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NoSignature.INSTANCE)) {
            icon = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return icon;
    }

    private static final HtmlChunk getToolTip(GitCommitSignature signature) {
        HtmlChunk htmlChunk;
        GitCommitSignature gitCommitSignature = signature;
        if (gitCommitSignature instanceof GitCommitSignature.Verified) {
            HtmlChunk htmlChunk2 = new HtmlBuilder().append(GitBundle.message("tooltip.commit.signature.verify.success", new Object[0])).append((HtmlChunk)HtmlChunk.br()).append(((GitCommitSignature.Verified)signature).getUser()).append((HtmlChunk)HtmlChunk.br()).append(((GitCommitSignature.Verified)signature).getFingerprint()).toFragment();
            htmlChunk = htmlChunk2;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"HtmlBuilder()\n        .a\u2026nt)\n        .toFragment()");
        } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NotVerified.INSTANCE)) {
            HtmlChunk htmlChunk3 = HtmlChunk.text((String)GitBundle.message("tooltip.commit.signature.verify.failure", new Object[0]));
            htmlChunk = htmlChunk3;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk3, (String)"HtmlChunk.text(message(\"\u2026gnature.verify.failure\"))");
        } else if (gitCommitSignature == null || Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NoSignature.INSTANCE)) {
            HtmlChunk htmlChunk4 = HtmlChunk.text((String)GitBundle.message("tooltip.no.commit.signature", new Object[0]));
            htmlChunk = htmlChunk4;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk4, (String)"HtmlChunk.text(message(\"\u2026ip.no.commit.signature\"))");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return htmlChunk;
    }

    public static final /* synthetic */ Icon access$getIcon(GitCommitSignature signature) {
        return GitCommitSignatureLogCellRendererKt.getIcon(signature);
    }

    public static final /* synthetic */ HtmlChunk access$getToolTip(GitCommitSignature signature) {
        return GitCommitSignatureLogCellRendererKt.getToolTip(signature);
    }
}

