/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.collect.Maps;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.config.GitSharedSettings;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteBranchOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitDeleteBranchOperation.class);
    static final String RESTORE = GitDeleteBranchOperation.getRestore();
    static final String VIEW_COMMITS = GitDeleteBranchOperation.getViewCommits();
    static final String DELETE_TRACKED_BRANCH = GitDeleteBranchOperation.getDeleteTrackedBranch();
    @NotNull
    private final String myBranchName;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final Map<GitRepository, GitRemoteBranch> myTrackedBranches;
    @NotNull
    private final Map<GitRepository, UnmergedBranchInfo> myUnmergedToBranches;
    @NotNull
    private final Map<GitRepository, String> myDeletedBranchTips;

    GitDeleteBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String branchName) {
        if (project == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(3);
        }
        if (branchName == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myBranchName = branchName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myTrackedBranches = GitDeleteBranchOperation.findTrackedBranches(repositories, branchName);
        this.myUnmergedToBranches = new HashMap<GitRepository, UnmergedBranchInfo>();
        this.myDeletedBranchTips = ContainerUtil.map2MapNotNull(repositories, repo -> {
            GitBranchesCollection branches2 = repo.getBranches();
            GitLocalBranch branch = branches2.findLocalBranch(this.myBranchName);
            if (branch == null) {
                LOG.error("Couldn't find branch by name " + this.myBranchName + " in " + repo);
                return null;
            }
            Hash hash = branches2.getHash(branch);
            if (hash == null) {
                LOG.error("Couldn't find hash for branch " + branch + " in " + repo);
                return null;
            }
            return Pair.create((Object)repo, (Object)hash.asString());
        });
    }

    @Override
    public void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitBranchNotMergedToUpstreamDetector notMergedToUpstreamDetector;
            GitSimpleEventDetector notFullyMergedDetector;
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.branchDelete(repository, this.myBranchName, false, notFullyMergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.BRANCH_NOT_FULLY_MERGED), notMergedToUpstreamDetector = new GitBranchNotMergedToUpstreamDetector());
            if (result2.success()) {
                GitDeleteBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            if (notFullyMergedDetector.hasHappened()) {
                String baseBranch = notMergedToUpstreamDetector.getBaseBranch();
                if (baseBranch == null) {
                    baseBranch = (String)this.myCurrentHeads.get(repository);
                }
                this.myUnmergedToBranches.put(repository, new UnmergedBranchInfo(this.myDeletedBranchTips.get(repository), GitBranchUtil.stripRefsPrefix(baseBranch)));
                GitCommandResult forceDeleteResult = this.myGit.branchDelete(repository, this.myBranchName, true, new GitLineHandlerListener[0]);
                if (forceDeleteResult.success()) {
                    GitDeleteBranchOperation.refresh(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                this.fatalError(this.getErrorTitle(), forceDeleteResult);
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError(this.getErrorTitle(), result2);
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
        }
    }

    @Override
    protected void notifySuccess() {
        boolean unmergedCommits = !this.myUnmergedToBranches.isEmpty();
        HtmlBuilder message = new HtmlBuilder().appendRaw(GitBundle.message("delete.branch.operation.deleted.branch.bold", this.myBranchName));
        if (unmergedCommits) {
            message.br().append(GitBundle.message("delete.branch.operation.unmerged.commits.were.discarded", new Object[0]));
        }
        Notification notification2 = VcsNotifier.STANDARD_NOTIFICATION.createNotification(message.toString(), NotificationType.INFORMATION);
        notification2.setDisplayId("git.branch.deleted");
        notification2.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getRestore(), () -> {
            notification2.expire();
            this.restoreInBackground(notification2);
        }));
        if (unmergedCommits) {
            notification2.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getViewCommits(), () -> this.viewUnmergedCommitsInBackground(notification2)));
        }
        if (!this.myTrackedBranches.isEmpty() && GitDeleteBranchOperation.hasNoOtherTrackingBranch(this.myTrackedBranches, this.myBranchName) && this.trackedBranchIsNotProtected()) {
            notification2.addAction((AnAction)NotificationAction.createSimple(() -> GitDeleteBranchOperation.getDeleteTrackedBranch(), () -> {
                notification2.expire();
                this.deleteTrackedBranchInBackground();
            }));
        }
        this.myNotifier.notify(notification2);
    }

    private boolean trackedBranchIsNotProtected() {
        return this.myTrackedBranches.values().stream().noneMatch(branch -> GitSharedSettings.getInstance(this.myProject).isBranchProtected(branch.getNameForRemoteOperations()));
    }

    private static boolean hasNoOtherTrackingBranch(@NotNull Map<GitRepository, GitRemoteBranch> trackedBranches, @NotNull String localBranch) {
        if (trackedBranches == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(5);
        }
        if (localBranch == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(6);
        }
        for (GitRepository repository : trackedBranches.keySet()) {
            if (!ContainerUtil.exists(repository.getBranchTrackInfos(), info -> !info.getLocalBranch().getName().equals(localBranch) && info.getRemoteBranch().equals(trackedBranches.get(repository)))) continue;
            return false;
        }
        return true;
    }

    private static void refresh(GitRepository ... repositories) {
        if (repositories == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(7);
        }
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = this.doRollback();
        if (!result2.totalSuccess()) {
            this.myNotifier.notifyError("git.branch.deletion.rollback.error", GitBundle.message("delete.branch.operation.error.during.rollback.of.branch.deletion", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    @NotNull
    private GitCompoundResult doRollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult setTrackResult;
            GitCommandResult res = this.myGit.branchCreate(repository, this.myBranchName, this.myDeletedBranchTips.get(repository));
            result2.append(repository, res);
            GitRemoteBranch trackedBranch = this.myTrackedBranches.get(repository);
            if (trackedBranch != null && !(setTrackResult = this.myGit.setUpstream(repository, trackedBranch.getNameForLocalOperations(), this.myBranchName)).success()) {
                LOG.warn("Couldn't set " + this.myBranchName + " to track " + trackedBranch + " in " + repository.getRoot().getName() + ": " + setTrackResult.getErrorOutputAsJoinedString());
            }
            GitDeleteBranchOperation.refresh(repository);
        }
        GitCompoundResult gitCompoundResult = result2;
        if (gitCompoundResult == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(8);
        }
        return gitCompoundResult;
    }

    @NotNull
    @NlsContexts.NotificationTitle
    private String getErrorTitle() {
        String string = GitBundle.message("delete.branch.operation.branch.was.not.deleted.error", this.myBranchName);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        String string = GitBundle.message("delete.branch.operation.deleted.branch", GitDeleteBranchOperation.formatBranchName(this.myBranchName));
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = new HtmlBuilder().append(GitBundle.message("delete.branch.operation.however.branch.deletion.has.succeeded.for.the.following", this.getSuccessfulRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("delete.branch.operation.you.may.rollback.not.to.let.branches.diverge", this.myBranchName)).toString();
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        String string = GitBundle.message("delete.branch.operation.name", new Object[0]);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String formatBranchName(@NotNull String name) {
        if (name == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(13);
        }
        String string = GitUIUtil.bold(GitUIUtil.code(name));
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(14);
        }
        return string;
    }

    private boolean showNotFullyMergedDialog(@NotNull Map<GitRepository, UnmergedBranchInfo> unmergedBranches) {
        if (unmergedBranches == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(15);
        }
        HashMap<GitRepository, List<GitCommit>> history = new HashMap<GitRepository, List<GitCommit>>();
        for (GitRepository repository : this.getRepositories()) {
            if (unmergedBranches.containsKey(repository)) {
                UnmergedBranchInfo unmergedInfo = unmergedBranches.get(repository);
                history.put(repository, GitDeleteBranchOperation.getUnmergedCommits(repository, unmergedInfo.myTipOfDeletedUnmergedBranch, unmergedInfo.myBaseBranch));
                continue;
            }
            history.put(repository, Collections.emptyList());
        }
        Map baseBranches = Maps.asMap(unmergedBranches.keySet(), it -> ((UnmergedBranchInfo)unmergedBranches.get((Object)it)).myBaseBranch);
        return this.myUiHandler.showBranchIsNotFullyMergedDialog(this.myProject, history, baseBranches, this.myBranchName);
    }

    @NotNull
    private static List<GitCommit> getUnmergedCommits(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String baseBranch) {
        List<GitCommit> list2;
        if (repository == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(16);
        }
        if (branchName == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(17);
        }
        if (baseBranch == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(18);
        }
        String range = baseBranch + ".." + branchName;
        try {
            list2 = GitHistoryUtils.history(repository.getProject(), repository.getRoot(), range);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get `git log " + range + "` in " + DvcsUtil.getShortRepositoryName((Repository)repository), (Throwable)e);
            List<GitCommit> list3 = Collections.emptyList();
            if (list3 == null) {
                GitDeleteBranchOperation.$$$reportNull$$$0(20);
            }
            return list3;
        }
        if (list2 == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    private static Map<GitRepository, GitRemoteBranch> findTrackedBranches(@NotNull Collection<? extends GitRepository> repositories, @NotNull String localBranchName) {
        if (repositories == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(21);
        }
        if (localBranchName == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(22);
        }
        HashMap<GitRepository, GitRemoteBranch> trackedBranches = new HashMap<GitRepository, GitRemoteBranch>();
        for (GitRepository gitRepository : repositories) {
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfo(gitRepository, localBranchName);
            if (trackInfo == null) continue;
            trackedBranches.put(gitRepository, trackInfo.getRemoteBranch());
        }
        HashMap<GitRepository, GitRemoteBranch> hashMap = trackedBranches;
        if (hashMap == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(23);
        }
        return hashMap;
    }

    private void deleteTrackedBranchInBackground() {
        GitBrancher brancher = GitBrancher.getInstance(this.myProject);
        MultiMap<String, GitRepository> grouped = this.groupTrackedBranchesByName();
        for (String remoteBranch : grouped.keySet()) {
            brancher.deleteRemoteBranch(remoteBranch, new ArrayList(grouped.get((Object)remoteBranch)));
        }
    }

    @NotNull
    private MultiMap<String, GitRepository> groupTrackedBranchesByName() {
        MultiMap trackedBranchNames = MultiMap.create();
        for (GitRepository repository : this.myTrackedBranches.keySet()) {
            GitRemoteBranch trackedBranch = this.myTrackedBranches.get(repository);
            if (trackedBranch == null) continue;
            trackedBranchNames.putValue((Object)trackedBranch.getNameForLocalOperations(), (Object)repository);
        }
        MultiMap multiMap = trackedBranchNames;
        if (multiMap == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(24);
        }
        return multiMap;
    }

    private void restoreInBackground(final @NotNull Notification notification2) {
        if (notification2 == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(25);
        }
        new Task.Backgroundable(this.myProject, GitBundle.message("delete.branch.operation.restoring.branch.process", this.myBranchName)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitDeleteBranchOperation.this.rollbackBranchDeletion(notification2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteBranchOperation$1", "run"));
            }
        }.queue();
    }

    private void rollbackBranchDeletion(@NotNull Notification notification2) {
        GitCompoundResult result2;
        if (notification2 == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(26);
        }
        if ((result2 = this.doRollback()).totalSuccess()) {
            notification2.expire();
        } else {
            this.myNotifier.notifyError("git.branch.deletion.rollback.error", GitBundle.message("delete.branch.operation.could.not.restore.branch.error", GitDeleteBranchOperation.formatBranchName(this.myBranchName)), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    private void viewUnmergedCommitsInBackground(final @NotNull Notification notification2) {
        if (notification2 == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(27);
        }
        new Task.Backgroundable(this.myProject, GitBundle.message("delete.branch.operation.collecting.unmerged.commits.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                boolean restore;
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (restore = GitDeleteBranchOperation.this.showNotFullyMergedDialog(GitDeleteBranchOperation.this.myUnmergedToBranches)) {
                    GitDeleteBranchOperation.this.rollbackBranchDeletion(notification2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteBranchOperation$2", "run"));
            }
        }.queue();
    }

    @NotNull
    static String getRestore() {
        String string = GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.restore", new Object[0]);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    static String getViewCommits() {
        String string = GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.view.commits", new Object[0]);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    static String getDeleteTrackedBranch() {
        String string = GitBundle.message("action.NotificationAction.GitDeleteBranchOperation.text.delete.tracked.branch", new Object[0]);
        if (string == null) {
            GitDeleteBranchOperation.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackedBranches";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranch";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitDeleteBranchOperation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unmergedBranches";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBranch";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitDeleteBranchOperation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doRollback";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBranchName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedCommits";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findTrackedBranches";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "groupTrackedBranchesByName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestore";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewCommits";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTrackedBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasNoOtherTrackingBranch";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatBranchName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showNotFullyMergedDialog";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedCommits";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findTrackedBranches";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "restoreInBackground";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "rollbackBranchDeletion";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "viewUnmergedCommitsInBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class UnmergedBranchInfo {
        @NotNull
        private final String myTipOfDeletedUnmergedBranch;
        @NotNull
        private final String myBaseBranch;

        UnmergedBranchInfo(@NotNull String tipOfDeletedUnmergedBranch, @NotNull String baseBranch) {
            if (tipOfDeletedUnmergedBranch == null) {
                UnmergedBranchInfo.$$$reportNull$$$0(0);
            }
            if (baseBranch == null) {
                UnmergedBranchInfo.$$$reportNull$$$0(1);
            }
            this.myTipOfDeletedUnmergedBranch = tipOfDeletedUnmergedBranch;
            this.myBaseBranch = baseBranch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tipOfDeletedUnmergedBranch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseBranch";
                    break;
                }
            }
            objectArray[1] = "git4idea/branch/GitDeleteBranchOperation$UnmergedBranchInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GitBranchNotMergedToUpstreamDetector
    implements GitLineHandlerListener {
        private static final Pattern PATTERN = Pattern.compile(".*'(.*)', even though it is merged to.*");
        @Nullable
        private String myBaseBranch;

        private GitBranchNotMergedToUpstreamDetector() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myBaseBranch = matcher.group(1);
            }
        }

        @Nullable
        public String getBaseBranch() {
            return this.myBaseBranch;
        }
    }
}

