/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ift;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.ift.GitProjectUtil;
import git4idea.index.actions.StagingAreaOperationActionKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.project.FileUtils;
import training.project.ProjectUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/ift/GitProjectUtil;", "", "()V", "remoteProjectName", "", "configureRemote", "", "remoteName", "remoteProjectRoot", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "copyGitProject", "", "destination", "createRemoteProject", "reCreateRemoteProjectDir", "refreshAndGetProjectRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "restoreGitLessonsFiles", "intellij.vcs.git.featuresTrainer"})
public final class GitProjectUtil {
    private static final String remoteProjectName = "RemoteLearningProject";
    @NotNull
    public static final GitProjectUtil INSTANCE;

    public final void restoreGitLessonsFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile learningProjectRoot = this.refreshAndGetProjectRoot(project);
        Object object = ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<VirtualFile>(project, learningProjectRoot){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $learningProjectRoot;

            @NotNull
            public final VirtualFile invoke() {
                boolean $i$f$runWriteAction = false;
                return (VirtualFile)ApplicationManager.getApplication().runWriteAction(new Computable(this){
                    final /* synthetic */ restoreGitLessonsFiles.gitProjectRoot.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        VirtualFile virtualFile;
                        block5: {
                            block4: {
                                boolean bl = false;
                                ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)this.this$0.$project);
                                Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
                                boolean bl2 = false;
                                projectLevelVcsManager.setDirectoryMappings((List)new ArrayList<E>());
                                virtualFile = this.this$0.$learningProjectRoot.findChild("git");
                                if (virtualFile == null) break block4;
                                VirtualFile virtualFile2 = virtualFile;
                                boolean bl3 = false;
                                boolean bl4 = false;
                                VirtualFile $this$apply = virtualFile2;
                                boolean bl5 = false;
                                VirtualFile virtualFile3 = $this$apply.findChild(".git");
                                if (virtualFile3 != null) {
                                    virtualFile3.delete((Object)$this$apply);
                                }
                                if ((virtualFile = virtualFile2) != null) break block5;
                            }
                            virtualFile = this.this$0.$learningProjectRoot.createChildDirectory((Object)GitProjectUtil.INSTANCE, "git");
                        }
                        return (T)virtualFile;
                    }
                });
            }
            {
                this.$project = project;
                this.$learningProjectRoot = virtualFile;
                super(0);
            }
        }), (int)1, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invokeAndWaitIfNeeded {\n\u2026his, \"git\")\n      }\n    }");
        VirtualFile gitProjectRoot2 = (VirtualFile)object;
        File file = gitProjectRoot2.toNioPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"gitProjectRoot.toNioPath().toFile()");
        boolean bl = this.copyGitProject(file);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean it = bl;
        boolean bl4 = false;
        if (!it) {
            String string = "Failed to copy git project";
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)gitProjectRoot2, (String)gitProjectRoot2.getPath());
    }

    @NotNull
    public final File createRemoteProject(@NotNull String remoteName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)remoteName, (String)"remoteName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File root = this.reCreateRemoteProjectDir();
        if (this.copyGitProject(root)) {
            this.configureRemote(remoteName, root, project);
            return root;
        }
        String string = "Failed to create remote project at path: " + root.getPath();
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final File reCreateRemoteProjectDir() {
        Object object;
        block9: {
            File projectsRoot;
            block8: {
                File file;
                int n;
                boolean bl;
                File[] fileArray;
                block7: {
                    projectsRoot = ProjectUtils.INSTANCE.getLearningProjectsPath().toFile();
                    File[] fileArray2 = projectsRoot.listFiles();
                    if (fileArray2 != null) {
                        fileArray = fileArray2;
                        bl = false;
                        File[] fileArray3 = fileArray;
                        boolean bl2 = false;
                        File[] fileArray4 = fileArray3;
                        int n2 = fileArray4.length;
                        for (n = 0; n < n2; ++n) {
                            File file2;
                            File it = file2 = fileArray4[n];
                            boolean bl3 = false;
                            File file3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it");
                            if (!Intrinsics.areEqual((Object)file3.getName(), (Object)remoteProjectName)) continue;
                            file = file2;
                            break block7;
                        }
                        file = null;
                    } else {
                        file = null;
                    }
                }
                fileArray = file;
                bl = false;
                boolean bl4 = false;
                File[] it = fileArray;
                boolean bl5 = false;
                object = it;
                if (it == null) break block8;
                File[] fileArray5 = object;
                n = 0;
                boolean bl6 = false;
                File[] $this$apply = fileArray5;
                boolean bl7 = false;
                FilesKt.deleteRecursively((File)$this$apply);
                object = fileArray5;
                if (fileArray5 != null) break block9;
            }
            StringBuilder stringBuilder = new StringBuilder();
            File file = projectsRoot;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"projectsRoot");
            object = new File(stringBuilder.append(file.getAbsolutePath()).append(File.separator).append(remoteProjectName).toString());
        }
        Object remoteProjectRoot = object;
        ((File)remoteProjectRoot).mkdir();
        return remoteProjectRoot;
    }

    private final boolean copyGitProject(File destination) {
        URL uRL = this.getClass().getClassLoader().getResource("learnProjects/GitProject");
        if (uRL == null) {
            String string = "GitProject not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        URL gitProjectURL = uRL;
        return FileUtils.copyResourcesRecursively$default((FileUtils)FileUtils.INSTANCE, (URL)gitProjectURL, (File)destination, null, (int)4, null);
    }

    private final void configureRemote(String remoteName, File remoteProjectRoot, Project project) {
        StagingAreaOperationActionKt.runProcess((Project)project, (String)"", (boolean)false, (Function0)((Function0)new Function0<Unit>(project, remoteName, remoteProjectRoot){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $remoteName;
            final /* synthetic */ File $remoteProjectRoot;

            public final void invoke() {
                Git git = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)git, (String)"Git.getInstance()");
                Git git2 = git;
                GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"GitRepositoryManager.getInstance(project)");
                List list = gitRepositoryManager.getRepositories();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"GitRepositoryManager.get\u2026nce(project).repositories");
                GitRepository repository = (GitRepository)CollectionsKt.first((List)list);
                git2.addRemote(repository, this.$remoteName, this.$remoteProjectRoot.getPath()).throwOnError(new int[0]);
                repository.update();
                GitRepository gitRepository = repository;
                Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repository");
                Collection collection = gitRepository.getRemotes();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
                git2.fetch(repository, (GitRemote)CollectionsKt.first((Iterable)collection), CollectionsKt.emptyList(), new String[0]).throwOnError(new int[0]);
                git2.setUpstream(repository, this.$remoteName + "/main", "main").throwOnError(new int[0]);
                repository.update();
            }
            {
                this.$project = project;
                this.$remoteName = string;
                this.$remoteProjectRoot = file;
                super(0);
            }
        }));
    }

    private final VirtualFile refreshAndGetProjectRoot(Project project) {
        Path path = ProjectUtils.INSTANCE.getProjectRoot(project).toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ProjectUtils.getProjectRoot(project).toNioPath()");
        Path learningProjectPath = path;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(learningProjectPath);
        if (virtualFile == null) {
            String string = "Learning project not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return virtualFile;
    }

    private GitProjectUtil() {
    }

    static {
        GitProjectUtil gitProjectUtil;
        INSTANCE = gitProjectUtil = new GitProjectUtil();
    }
}

