/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerVersionConfig;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.javaee.oss.util.VersionUtil;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class TomcatServerVersionConfig
extends JavaeeServerVersionConfig {
    private static final JavaeeServerVersionConfig.Factory<JavaeePersistentData> ourFactory = new JavaeeServerVersionConfig.Factory<JavaeePersistentData>(){

        @NotNull
        public TomcatServerVersionConfig createConfig(JavaeePersistentData data) {
            return new TomcatServerVersionConfig();
        }
    };

    private TomcatServerVersionConfig() {
    }

    protected JavaeeServerVersionDescriptor getVersionDescriptor(String home) throws Exception {
        String version;
        File catalinaJar = new File(home, "lib/catalina.jar");
        boolean isServerLib = false;
        if (!catalinaJar.exists()) {
            catalinaJar = new File(home, "server/lib/catalina.jar");
            isServerLib = true;
            if (!catalinaJar.exists()) {
                throw new IOException("Can't find catalina.jar");
            }
        }
        try {
            String versionProperty = StringUtil.notNullize((String)VersionUtil.readJarProperty((File)catalinaJar, (String)"org/apache/catalina/util/ServerInfo.properties", (String)"server.info"));
            version = StringUtil.trimStart((String)versionProperty, (String)"Apache Tomcat/");
            if (StringUtil.isEmpty((String)version)) {
                version = JarVersionDetectionUtil.getImplementationVersion((File)catalinaJar);
            }
            if (StringUtil.isEmpty((String)version)) {
                throw new IOException("Version properties are empty");
            }
        }
        catch (IOException e) {
            if (!isServerLib) {
                throw e;
            }
            version = "4.0.x";
        }
        return new JavaeeServerVersionDescriptor(version, catalinaJar);
    }

    public static String get(JavaeePersistentData persistentData) throws Exception {
        return TomcatServerVersionConfig.get(ourFactory, (JavaeePersistentData)persistentData);
    }
}

