/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.appServers.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.oss.server.JavaeeConfigurationType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.deployment.JspDeploymentManager;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatPersistentDataWrapper;
import org.jetbrains.idea.tomcat.TomcatStartupPolicy;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;
import org.jetbrains.idea.tomcat.server.TomcatRemoteModel;

public abstract class TomcatConfigurationBase
extends JavaeeConfigurationType {
    public TomcatConfigurationBase(@NotNull String id) {
        if (id == null) {
            TomcatConfigurationBase.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @NotNull
    protected ServerModel createLocalModel() {
        return new TomcatLocalModel();
    }

    @NotNull
    protected ServerModel createRemoteModel() {
        return new TomcatRemoteModel();
    }

    @NotNull
    protected ExecutableObjectStartupPolicy createStartupPolicy() {
        return new TomcatStartupPolicy();
    }

    public String getUrlToOpenInBrowser(@NotNull ApplicationServer server, @NotNull PsiFile psiFile) {
        WebFacet webFacet;
        if (server == null) {
            TomcatConfigurationBase.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            TomcatConfigurationBase.$$$reportNull$$$0(2);
        }
        if ((webFacet = WebUtil.getWebFacet((PsiElement)psiFile)) == null) {
            return null;
        }
        int port = new TomcatPersistentDataWrapper(server).getSourceLocalPort();
        @NonNls String root = "http://localhost:" + port;
        String relativePath = JspDeploymentManager.getInstance().computeRelativeTargetPath(psiFile, webFacet);
        if (relativePath == null) {
            return null;
        }
        return DeploymentUtil.concatPaths((String[])new String[]{root, relativePath});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/tomcat/server/TomcatConfigurationBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUrlToOpenInBrowser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

