/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.admin;

import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.admin.jmx.JavaeeJmxAdminServerBase;
import com.intellij.javaee.oss.admin.jmx.JmxAdminException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.tomcat.TomcatDeploymentModelBase;

public abstract class TomcatJmxAdminServerBase
extends JavaeeJmxAdminServerBase {
    private static final Logger LOG = Logger.getInstance(TomcatJmxAdminServerBase.class);
    @NonNls
    private static final String MBEAN_FACTORY_SUFFIX = "type=MBeanFactory";
    @NonNls
    private static final String MBEAN_HOST_SUFFIX = "type=Host,host=localhost";
    @NonNls
    private static final String MBEAN_SERVER_SUFFIX = "type=Server";
    @NonNls
    private static final String MBEAN_DEPLOYER_SUFFIX = "type=Deployer,host=localhost";
    @NonNls
    private static final String[] STARTING_STATE_NAMES = new String[]{"NEW", "INITIALIZING", "INITIALIZED", "STARTING_PREP", "STARTING"};
    private final String myRootName;
    private final String myJmxUsername;
    private final String myJmxPassword;

    public TomcatJmxAdminServerBase(@NonNls String rootName, @Nullable String jmxUsername, @Nullable String jmxPassword) {
        this.myRootName = rootName;
        this.myJmxUsername = jmxUsername;
        this.myJmxPassword = jmxPassword;
    }

    protected final String getFactoryObjectName() {
        return this.myRootName + ":type=MBeanFactory";
    }

    protected final String getHostObjectName() {
        return this.myRootName + ":type=Host,host=localhost";
    }

    protected final String getServerObjectName() {
        return this.myRootName + ":type=Server";
    }

    protected final String getDeployerObjectName() {
        return this.myRootName + ":type=Deployer,host=localhost";
    }

    protected String getDeploymentMBean(TomcatDeploymentModelBase deploymentModel) {
        String contextPath = deploymentModel.getContextPath();
        return this.myRootName + ":j2eeType=WebModule,name=//localhost" + (StringUtil.isEmpty((String)contextPath) ? "/" : contextPath) + ",J2EEApplication=none,J2EEServer=none";
    }

    protected boolean isUndeploySyncNeeded() {
        return true;
    }

    protected DeploymentStatus doGetDeploymentStatus(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        TomcatDeploymentModelBase tomcatDeployment = (TomcatDeploymentModelBase)context.getDeploymentModel();
        ReadStateCommand readStateCommand = this.isStateReadByName() ? new ReadStateCommand<String>(tomcatDeployment){

            @Override
            protected String getAttributeName() {
                return "stateName";
            }

            @Override
            protected String getStartedAttributeValue() {
                return "STARTED";
            }

            @Override
            public boolean isStarting() {
                for (String startingStateName : STARTING_STATE_NAMES) {
                    if (!this.isAttributeValueEquals(startingStateName)) continue;
                    return true;
                }
                return false;
            }
        } : new ReadStateCommand<Integer>(tomcatDeployment){

            @Override
            protected String getAttributeName() {
                return "state";
            }

            @Override
            protected Integer getStartedAttributeValue() {
                return 1;
            }

            @Override
            public boolean isStarting() {
                return false;
            }
        };
        readStateCommand.readAttribute();
        if (readStateCommand.isExist()) {
            if (readStateCommand.isStarting()) {
                return DeploymentStatus.ACTIVATING;
            }
            if (readStateCommand.isStarted()) {
                return DeploymentStatus.DEPLOYED;
            }
            return DeploymentStatus.FAILED;
        }
        return DeploymentStatus.NOT_DEPLOYED;
    }

    protected abstract boolean isStateReadByName();

    protected abstract TomcatConnectorCommandBase<Boolean> createConnectCommand();

    private abstract class ReadStateCommand<V>
    extends ReadAttributeCommand<V> {
        ReadStateCommand(TomcatDeploymentModelBase deploymentModel) {
            super(deploymentModel);
        }

        public boolean isStarted() {
            return this.isAttributeValueEquals(this.getStartedAttributeValue());
        }

        public abstract boolean isStarting();

        protected abstract V getStartedAttributeValue();
    }

    protected abstract class ReadAttributeCommand<V>
    extends TomcatConnectorCommandBase<V> {
        private final String myDeploymentMBean;
        private V myAttributeValue;

        public ReadAttributeCommand(TomcatDeploymentModelBase deploymentModel) {
            this.myDeploymentMBean = TomcatJmxAdminServerBase.this.getDeploymentMBean(deploymentModel);
        }

        protected V doExecute(MBeanServerConnection connection) throws JMException, IOException {
            return (V)ReadAttributeCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)ReadAttributeCommand.createObjectName((String)this.myDeploymentMBean), (String)this.getAttributeName());
        }

        public void readAttribute() throws JmxAdminException {
            this.myAttributeValue = this.adminExecute();
            LOG.debug("state: " + this.myAttributeValue);
        }

        public boolean isExist() {
            return this.myAttributeValue != null;
        }

        protected final boolean isAttributeValueEquals(V expectedAttributeValue) {
            return expectedAttributeValue.equals(this.myAttributeValue);
        }

        @NonNls
        protected abstract String getAttributeName();
    }

    protected abstract class TomcatConnectorCommandBase<R>
    extends JavaeeJmxAdminServerBase.JmxAdminCommandBase<R> {
        protected TomcatConnectorCommandBase() {
            super((JavaeeJmxAdminServerBase)TomcatJmxAdminServerBase.this);
        }

        protected Integer getTimeoutSeconds() {
            return 600;
        }

        @Nullable
        protected String getJmxUsername() {
            return TomcatJmxAdminServerBase.this.myJmxUsername;
        }

        @Nullable
        protected String getJmxPassword() {
            return TomcatJmxAdminServerBase.this.myJmxPassword;
        }
    }
}

