/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.admin;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallback;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.admin.jmx.JavaeeJmxAdminServerBase;
import com.intellij.javaee.oss.admin.jmx.JmxAdminException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.tomcat.TomcatDeploymentModelBase;
import org.jetbrains.idea.tomcat.admin.TomEEAgentAdminServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatJmxAdminServerBase;
import org.jetbrains.idea.tomcat.server.TomcatServerModel;

public abstract class TomcatAdminServerBase<T extends TomcatServerModel>
extends TomcatJmxAdminServerBase {
    protected static final Logger LOG = Logger.getInstance(TomcatAdminServerBase.class);
    private final T myServerModel;
    private final TomEEAgentAdminServerImpl myTomEEAdmin;
    private boolean myStateReadByName;
    private boolean myServerStateAvailable;
    private boolean myDeployerAvailable;

    public TomcatAdminServerBase(T serverModel, @Nullable TomEEAgentAdminServerImpl tomEEAdmin, @Nullable String jmxUsername, @Nullable String jmxPassword) {
        super("Catalina", jmxUsername, jmxPassword);
        this.myServerModel = serverModel;
        this.myTomEEAdmin = tomEEAdmin;
    }

    @Override
    protected TomcatJmxAdminServerBase.TomcatConnectorCommandBase<Boolean> createConnectCommand() {
        return new TomcatJmxAdminServerBase.TomcatConnectorCommandBase<Boolean>(){

            protected Boolean doExecute(MBeanServerConnection connection) throws JMException, IOException {
                if (TomcatAdminServerBase.this.myServerStateAvailable && !"STARTED".equals(1.getAttribute((MBeanServerConnection)connection, (ObjectName)1.createObjectName((String)TomcatAdminServerBase.this.getServerObjectName()), (String)"stateName"))) {
                    return false;
                }
                String attributeName = "modelerType";
                1.getAttribute((MBeanServerConnection)connection, (ObjectName)1.createObjectName((String)TomcatAdminServerBase.this.getFactoryObjectName()), (String)"modelerType");
                if (TomcatAdminServerBase.this.myDeployerAvailable) {
                    1.getAttribute((MBeanServerConnection)connection, (ObjectName)1.createObjectName((String)TomcatAdminServerBase.this.getDeployerObjectName()), (String)"modelerType");
                }
                return true;
            }
        };
    }

    public void start(String host, int port, String username, String password, JavaeeAdminStartCallback callback) throws Exception {
        this.myStateReadByName = ((TomcatServerModel)((Object)this.myServerModel)).isVersionHigher6032();
        this.myServerStateAvailable = ((TomcatServerModel)((Object)this.myServerModel)).isVersion7OrHigher();
        this.myDeployerAvailable = ((TomcatServerModel)((Object)this.myServerModel)).versionHigher(5, 5, 0);
        super.start(host, port, username, password, callback);
        if (this.myTomEEAdmin != null) {
            this.myTomEEAdmin.start(host, this.myServerModel.getCommonModel().getPort(), username, password, callback);
        }
    }

    public final boolean doConnect() {
        return this.doConnectTomcat() && (this.myTomEEAdmin == null || this.myTomEEAdmin.doConnect());
    }

    protected final boolean doConnectJmx() {
        return super.doConnect();
    }

    protected abstract boolean doConnectTomcat();

    public void shutdown() {
        if (this.myTomEEAdmin != null) {
            this.myTomEEAdmin.shutdown();
        }
        super.shutdown();
    }

    protected final boolean isUseJmx() {
        return ((TomcatServerModel)((Object)this.myServerModel)).isUseJmx();
    }

    @Override
    protected boolean isStateReadByName() {
        return this.myStateReadByName;
    }

    protected final T getServerModel() {
        return this.myServerModel;
    }

    public void startDeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        if (this.useTomEEAdmin(deployment)) {
            this.myTomEEAdmin.startDeploy(deployment, source, callback);
            return;
        }
        super.startDeploy(deployment, source, callback);
    }

    public void startUndeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        if (this.useTomEEAdmin(deployment)) {
            this.myTomEEAdmin.startUndeploy(deployment, source, callback);
            return;
        }
        super.startUndeploy(deployment, source, callback);
    }

    public void startUpdateDeploymentStatus(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        if (this.useTomEEAdmin(deployment)) {
            this.myTomEEAdmin.startUpdateDeploymentStatus(deployment, source, callback);
            return;
        }
        super.startUpdateDeploymentStatus(deployment, source, callback);
    }

    private boolean useTomEEAdmin(DeploymentModel deployment) {
        return this.myTomEEAdmin != null && ((TomcatServerModel)deployment.getServerModel()).useTomEEDeployer(deployment);
    }

    protected boolean doDeploy(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        TomcatDeploymentModelBase tomcatDeployment = (TomcatDeploymentModelBase)context.getDeploymentModel();
        final String deploymentPath = this.prepareDeployment(tomcatDeployment, context.getSource().getAbsolutePath());
        final String contextPath = tomcatDeployment.getContextPath();
        String deploymentMBean = (String)new TomcatJmxAdminServerBase.TomcatConnectorCommandBase<String>(){

            protected String doExecute(MBeanServerConnection connection) throws JMException, IOException {
                return (String)2.invokeOperation((MBeanServerConnection)connection, (ObjectName)2.createObjectName((String)TomcatAdminServerBase.this.getFactoryObjectName()), (String)"createStandardContext", (Object[])new Object[]{TomcatAdminServerBase.this.getHostObjectName(), contextPath, deploymentPath});
            }

            @Override
            protected Integer getTimeoutSeconds() {
                return null;
            }
        }.adminExecute();
        String expectedDeploymentMBean = this.getDeploymentMBean(tomcatDeployment);
        if (!expectedDeploymentMBean.equals(deploymentMBean)) {
            LOG.debug("Unexpected deployment MBean: '" + deploymentMBean + "', while '" + expectedDeploymentMBean + "' is expected");
            return false;
        }
        return true;
    }

    protected abstract String prepareDeployment(TomcatDeploymentModelBase var1, String var2) throws JmxAdminException;

    protected boolean doUndeploy(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        TomcatDeploymentModelBase tomcatDeployment = (TomcatDeploymentModelBase)context.getDeploymentModel();
        final String deploymentMBean = this.getDeploymentMBean(tomcatDeployment);
        new TomcatJmxAdminServerBase.TomcatConnectorCommandBase(){

            protected Object doExecute(MBeanServerConnection connection) throws JMException, IOException {
                return 3.invokeOperation((MBeanServerConnection)connection, (ObjectName)3.createObjectName((String)TomcatAdminServerBase.this.getFactoryObjectName()), (String)"removeContext", (Object[])new Object[]{deploymentMBean});
            }
        }.adminExecute();
        return true;
    }
}

