/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.javaee.appServers.context.DeploymentModelContext;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.idea.tomcat.TomcatDeploymentModelBase;
import org.jetbrains.idea.tomcat.TomcatUtil;
import org.jetbrains.idea.tomcat.server.TomcatServerModel;

public class TomcatModuleDeploymentModel
extends TomcatDeploymentModelBase
implements DeploymentModelContext {
    public String CONTEXT_PATH = "/";

    public TomcatModuleDeploymentModel(CommonModel parentConfiguration, DeploymentSource source) {
        super(parentConfiguration, source);
        if (!this.isEEArtifact() && !Registry.is((String)"tomcat.root.context.by.default", (boolean)false)) {
            this.CONTEXT_PATH = this.getContextPathBasedOnDeploymentSource();
        }
    }

    @Override
    public String getContextPath() {
        if (this.isEEArtifact()) {
            return this.getContextPathBasedOnDeploymentSource();
        }
        return this.getContextRoot();
    }

    private String getContextPathBasedOnDeploymentSource() {
        return "/" + FileUtil.sanitizeFileName((String)this.getDeploymentSource().getPresentableName());
    }

    public TomcatServerModel getServerModel() {
        return (TomcatServerModel)super.getServerModel();
    }

    public boolean isDefaultContextRoot() {
        return this.isEEArtifact();
    }

    public String getContextRoot() {
        Object result = this.CONTEXT_PATH;
        Element contextRoot = TomcatUtil.findContextInContextXmlByFacet(this);
        if (StringUtil.isEmpty((String)result) && contextRoot != null && !this.getServerModel().isTomEE()) {
            result = contextRoot.getAttributeValue("path");
        }
        if (!StringUtil.startsWithChar((CharSequence)result, (char)'/')) {
            result = "/" + (String)result;
        }
        if ("/".equals(result)) {
            result = "";
        }
        return result;
    }
}

