/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatContextItem;
import org.jetbrains.idea.tomcat.TomcatServerXmlWrapper;
import org.jetbrains.idea.tomcat.TomcatUtil;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;

public class TomcatContexts {
    private static final Logger LOG = Logger.getInstance(TomcatContexts.class);
    @NonNls
    public static final String CONTEXT_ELEMENT_NAME = "Context";
    @NonNls
    public static final String PATH_ATTR = "path";
    @NonNls
    public static final String DOC_BASE_ATTR = "docBase";
    @NonNls
    public static final String ROOT_DIR_NAME = "ROOT";
    @NonNls
    private static final String XML_EXTENSION = "xml";
    @NonNls
    private static final String CONTEXT_PATH_SEPARATOR = "/";
    @NonNls
    private static final String CONTEXT_PATH_SEPARATOR_IN_FILE_NAME = "#";
    private final TomcatServerXmlWrapper myServerXml;
    private final Element myLocalHost;
    private final List<TomcatContextItem> myItems;

    public TomcatContexts(TomcatLocalModel tomcatModel, String baseDirPath) throws ExecutionException {
        File hostDir;
        File[] contextFiles;
        this.myServerXml = new TomcatServerXmlWrapper(baseDirPath);
        this.myItems = new ArrayList<TomcatContextItem>();
        this.myLocalHost = this.myServerXml.findLocalHost();
        List contextElements = this.myLocalHost.getChildren(CONTEXT_ELEMENT_NAME);
        for (final Element contextElement : contextElements) {
            this.myItems.add(new TomcatContextItem(contextElement, contextElement.getAttributeValue(PATH_ATTR)){

                @Override
                public void remove() throws ExecutionException {
                    TomcatContexts.this.myLocalHost.removeContent((Content)contextElement);
                    TomcatContexts.this.myServerXml.save();
                }
            });
        }
        if (tomcatModel != null && tomcatModel.isVersion5OrHigher() && (contextFiles = (hostDir = new File(TomcatUtil.hostDir(baseDirPath))).listFiles()) != null) {
            for (final File contextFile : contextFiles) {
                Element rootElement;
                if (!FileUtilRt.extensionEquals((String)contextFile.getName(), (String)XML_EXTENSION)) continue;
                try {
                    rootElement = TomcatUtil.loadXMLFile(contextFile);
                }
                catch (ExecutionException e) {
                    LOG.info((Throwable)e);
                    continue;
                }
                if (!CONTEXT_ELEMENT_NAME.equals(rootElement.getName())) continue;
                Object path = FileUtilRt.getNameWithoutExtension((String)contextFile.getName());
                if (ROOT_DIR_NAME.equals(path)) {
                    path = "";
                }
                path = CONTEXT_PATH_SEPARATOR + ((String)path).replace(CONTEXT_PATH_SEPARATOR_IN_FILE_NAME, CONTEXT_PATH_SEPARATOR);
                this.myItems.add(new TomcatContextItem(rootElement, (String)path){

                    @Override
                    public void remove() throws ExecutionException {
                        if (!contextFile.delete()) {
                            throw new ExecutionException(TomcatBundle.message("exception.text.cannot.delete.file", contextFile.getAbsolutePath()));
                        }
                    }
                });
            }
        }
    }

    public List<TomcatContextItem> getItems() {
        return this.myItems;
    }

    @Nullable
    public Element findContextByPath(String contextPath) {
        if (StringUtil.isEmpty((String)contextPath)) {
            contextPath = CONTEXT_PATH_SEPARATOR;
        }
        for (TomcatContextItem item : this.myItems) {
            if (!contextPath.equals(item.getPath())) continue;
            return item.getElement();
        }
        return null;
    }

    public Collection<@NlsSafe String> getContextPaths() {
        HashSet<String> result = new HashSet<String>();
        for (TomcatContextItem item : this.myItems) {
            @NlsSafe String contextPath = item.getPath();
            if (contextPath == null) continue;
            result.add(contextPath);
        }
        return result;
    }

    public void addOrRemoveContextElementInServerXml(String contextPath, @Nullable Element newContext) throws ExecutionException {
        Element oldContext = this.findContextByPath(contextPath);
        if (oldContext != null) {
            this.myLocalHost.removeContent((Content)oldContext);
        }
        if (newContext != null) {
            this.myLocalHost.addContent(newContext.clone());
        }
        this.myServerXml.save();
    }
}

