/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.util.JavaeeJdomUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;

public class Tomcat4Deployer {
    private static final Logger LOG = Logger.getInstance(Tomcat4Deployer.class);
    private final TomcatLocalModel myModel;
    private static final int TIMEOUT = 5000;
    @NonNls
    private static final String IDEA_MANAGER_USERNAME = "idea_manager";
    @NonNls
    private static final String IDEA_MANAGER_PASSWORD = "idea_manager";
    @NonNls
    private static final String AUTHORIZATION_STRING = "idea_manager:idea_manager";
    @NonNls
    private static final String USER_ELEMENT = "user";
    @NonNls
    private static final String USERNAME_ATTRIBUTE = "name";
    @NonNls
    private static final String PASSWORD_ATTRIBUTE = "password";
    @NonNls
    private static final String ROLES_ATTRIBUTE = "roles";
    @NonNls
    private static final String MANAGER_ROLE = "manager";
    @NonNls
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    @NonNls
    private static final String BASIC_AUTHORIZATION_METHOD = "Basic ";
    @NonNls
    private static final String FAIL_MESSAGE_PREFIX = "FAIL -";

    public Tomcat4Deployer(TomcatLocalModel model) {
        this.myModel = model;
    }

    public void deploy(String contextPath) {
        this.startCommand("manager/start?path=" + Tomcat4Deployer.adjustContextPath(contextPath));
    }

    public void undeploy(String contextPath) {
        this.startCommand("manager/stop?path=" + Tomcat4Deployer.adjustContextPath(contextPath));
    }

    private static String adjustContextPath(String contextPath) {
        if (contextPath.length() == 0) {
            return "/";
        }
        return contextPath;
    }

    private void startCommand(@NonNls String commandUrl) {
        String managerUrl = ApplicationServerUrlMapping.createUrl((CommonModel)this.myModel.getCommonModel(), null, null) + commandUrl;
        ApplicationManager.getApplication().executeOnPooledThread(() -> Tomcat4Deployer.runManagerCommand(managerUrl));
    }

    private static boolean runManagerCommand(String managerUrl) {
        try {
            URL url = new URL(managerUrl);
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < 5000L) {
                String msg;
                LOG.debug("Running server command: " + managerUrl);
                URLConnection urlConnection = url.openConnection();
                urlConnection.setDoInput(true);
                urlConnection.setDoOutput(false);
                String encoded = Base64.getEncoder().encodeToString(AUTHORIZATION_STRING.getBytes(StandardCharsets.UTF_8));
                urlConnection.setRequestProperty(AUTHORIZATION_PROPERTY, BASIC_AUTHORIZATION_METHOD + encoded);
                urlConnection.connect();
                try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    msg = StreamUtil.readText((Reader)reader);
                }
                LOG.debug("Server returned: " + msg);
                if (msg == null) continue;
                return !msg.startsWith(FAIL_MESSAGE_PREFIX);
            }
            return false;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static void addManagerUser(File tomcatUsersFile) {
        try {
            Document document = JavaeeJdomUtil.loadDocument((File)tomcatUsersFile);
            Element root = document.getRootElement();
            Element userElement = new Element(USER_ELEMENT);
            userElement.setAttribute(USERNAME_ATTRIBUTE, "idea_manager");
            userElement.setAttribute(PASSWORD_ATTRIBUTE, "idea_manager");
            userElement.setAttribute(ROLES_ATTRIBUTE, MANAGER_ROLE);
            root.addContent(userElement);
            JDOMUtil.writeDocument((Document)document, (File)tomcatUsersFile, (String)System.lineSeparator());
        }
        catch (IOException | JDOMException e) {
            LOG.debug(e);
        }
    }
}

