/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.view;

import com.intellij.batch.model.job.Job;
import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.batch.view.BatchStepsPanel;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import icons.BatchCoreIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchJobsRecursivePanel
extends FinderRecursivePanel<Job> {
    private final Module myModule;

    public BatchJobsRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions) {
        if (parent == null) {
            BatchJobsRecursivePanel.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull Job job) {
        if (job == null) {
            BatchJobsRecursivePanel.$$$reportNull$$$0(1);
        }
        if (this.hasChildren(job)) {
            return new BatchStepsPanel(this, this.getModule());
        }
        return super.createRightComponent((Object)job);
    }

    private JComponent getJobDescriptorInfoPanel(Job job) {
        return DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)job.getXmlElement(), (Disposable)this);
    }

    @NotNull
    protected String getItemText(@NotNull Job job) {
        String name;
        if (job == null) {
            BatchJobsRecursivePanel.$$$reportNull$$$0(2);
        }
        String string = (name = job.getId().getStringValue()) == null ? "" : name;
        if (string == null) {
            BatchJobsRecursivePanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(@NotNull Job job) {
        if (job == null) {
            BatchJobsRecursivePanel.$$$reportNull$$$0(4);
        }
        return BatchCoreIcons.Batch;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            BatchJobsRecursivePanel.$$$reportNull$$$0(5);
        }
        Job value = (Job)this.getSelectedValue();
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && value != null) {
            return value.getXmlElement();
        }
        return super.getData(dataId);
    }

    @NotNull
    protected List<Job> getListItems() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (this.myModule != null) {
            jobs.addAll(BatchCommonUtils.getBatchJobs(this.myModule));
        } else {
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                if (!BatchCommonUtils.isBatchInstalled(module)) continue;
                jobs.addAll(BatchCommonUtils.getBatchJobs(module));
            }
        }
        jobs.sort((o1, o2) -> {
            String value1 = o1.getId().getStringValue();
            String value2 = o2.getId().getStringValue();
            if (value1 != null && value2 != null) {
                return value1.compareTo(value2);
            }
            return 0;
        });
        ArrayList<Job> arrayList = jobs;
        if (arrayList == null) {
            BatchJobsRecursivePanel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected boolean hasChildren(@NotNull Job job) {
        if (job == null) {
            BatchJobsRecursivePanel.$$$reportNull$$$0(7);
        }
        return BatchCommonUtils.getAllIdentified(job).size() > 0;
    }

    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/view/BatchJobsRecursivePanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/view/BatchJobsRecursivePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

