/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.inspections;

import com.intellij.batch.RequiredArtifactType;
import com.intellij.batch.model.BatchArtifactRefBean;
import com.intellij.batch.model.job.Job;
import com.intellij.batch.resources.BatchBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RequiredArtifactTypeInspection
extends DomElementsInspection<Job> {
    public RequiredArtifactTypeInspection() {
        super(Job.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (!(element instanceof GenericAttributeValue)) {
            return;
        }
        Object value = ((GenericAttributeValue)element).getValue();
        if (value == null) {
            return;
        }
        if (value instanceof BatchArtifactRefBean) {
            List<PsiClass> foundRequiredClasses = RequiredArtifactTypeInspection.getRequiredArtifactTypeClasses(element);
            BatchArtifactRefBean artifactRef = (BatchArtifactRefBean)value;
            PsiType type = artifactRef.getType();
            RequiredArtifactTypeInspection.checkArtifactType(element, holder, foundRequiredClasses, type);
        }
    }

    @NotNull
    public static List<PsiClass> getRequiredArtifactTypeClasses(@NotNull DomElement element) {
        RequiredArtifactType type;
        if (element == null) {
            RequiredArtifactTypeInspection.$$$reportNull$$$0(0);
        }
        if ((type = (RequiredArtifactType)element.getAnnotation(RequiredArtifactType.class)) == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                RequiredArtifactTypeInspection.$$$reportNull$$$0(1);
            }
            return list;
        }
        SmartList types = new SmartList();
        for (String className : type.value()) {
            PsiClass psiClass = DomJavaUtil.findClass((String)className, (DomElement)element);
            if (psiClass == null) continue;
            types.add(psiClass);
        }
        SmartList smartList = types;
        if (smartList == null) {
            RequiredArtifactTypeInspection.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static void checkArtifactType(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull List<PsiClass> psiClasses, @Nullable PsiType type) {
        if (element == null) {
            RequiredArtifactTypeInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            RequiredArtifactTypeInspection.$$$reportNull$$$0(4);
        }
        if (psiClasses == null) {
            RequiredArtifactTypeInspection.$$$reportNull$$$0(5);
        }
        if (type == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)element.getManager().getProject()).getElementFactory();
        for (PsiClass requiredClass : psiClasses) {
            PsiClassType reqType = factory.createType(requiredClass);
            if (!reqType.isAssignableFrom(type)) continue;
            return;
        }
        List names = ContainerUtil.map(psiClasses, psiClass -> psiClass.getQualifiedName());
        String classText = psiClasses.size() == 1 ? (String)names.get(0) : StringUtil.join((Collection)names, (String)",");
        String message = psiClasses.size() == 1 ? BatchBundle.message("artifact.must.be.of.type", classText) : BatchBundle.message("artifact.must.be.one.of.these.types", classText);
        holder.createProblem(element, message, new LocalQuickFix[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/inspections/RequiredArtifactTypeInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/inspections/RequiredArtifactTypeInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredArtifactTypeClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredArtifactTypeClasses";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkArtifactType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

