/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.MutableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.ReplaceableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.api.SharedIndexStorage;
import com.intellij.indexing.shared.platform.impl.BundledSharedIndexesResolver;
import com.intellij.indexing.shared.platform.impl.ChunkStorageOption;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorage;
import com.intellij.indexing.shared.platform.impl.SharedIndexStorageHolder;
import com.intellij.indexing.shared.platform.impl.SharedIndexStorageHolder$WhenMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u001d\u0010\u0017\u001a\u00020\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0019H\u0082\bJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u001f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder;", "Ljava/io/Closeable;", "mutableStorage", "Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;", "providedStorages", "", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStorage;", "replaceableChunkStorages", "", "Lcom/intellij/indexing/shared/platform/api/ReplaceableSharedIndexStorage;", "(Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;Ljava/util/List;Ljava/util/List;)V", "storageId", "", "getStorageId", "()Ljava/lang/String;", "addChunk", "", "chunkSourcePath", "Ljava/nio/file/Path;", "chunkId", "option", "Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "close", "foreachStorage", "action", "Lkotlin/Function1;", "getChunkRoot", "getSharedIndexStats", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "isCompatibleChunk", "", "toString", "Companion", "intellij.indexing.shared"})
public final class SharedIndexStorageHolder
implements Closeable {
    private final MutableSharedIndexStorage mutableStorage;
    private final List<SharedIndexStorage> providedStorages;
    private final List<ReplaceableSharedIndexStorage> replaceableChunkStorages;
    private static final Logger LOG;
    private static final String MAIN_STORAGE_OLD_NAME = "chunks.zip";
    @NotNull
    public static final String MAIN_STORAGE_NAME = "shared-index.chunks";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String toString() {
        SharedIndexStorage it$iv;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append("CompositeStorage{");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl6 = false;
        $this$buildString.append(it.toString()).append(", ");
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl7 = false;
            it = it$iv;
            bl6 = false;
            $this$buildString.append(it.toString()).append(", ");
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl8 = false;
            it = it$iv;
            bl6 = false;
            $this$buildString.append(it.toString()).append(", ");
        }
        $this$buildString.append("}");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final void foreachStorage(Function1<? super SharedIndexStorage, Unit> action) {
        SharedIndexStorage it;
        int $i$f$foreachStorage = 0;
        action.invoke((Object)this.mutableStorage);
        Iterable $this$forEach$iv = this.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SharedIndexStorage)element$iv;
            boolean bl = false;
            action.invoke((Object)it);
        }
        $this$forEach$iv = this.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ReplaceableSharedIndexStorage)element$iv;
            boolean bl = false;
            action.invoke((Object)it);
        }
    }

    @Nullable
    public final Path getChunkRoot(@NotNull String chunkId) {
        SharedIndexStorage it$iv;
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        Path chunkRoot = it.getChunkRoot(chunkId);
        if (chunkRoot != null) {
            return chunkRoot;
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            chunkRoot = it.getChunkRoot(chunkId);
            if (chunkRoot == null) continue;
            return chunkRoot;
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            chunkRoot = it.getChunkRoot(chunkId);
            if (chunkRoot == null) continue;
            return chunkRoot;
        }
        return null;
    }

    public final void addChunk(@NotNull Path chunkSourcePath, @NotNull String chunkId, @NotNull ChunkStorageOption option) {
        Intrinsics.checkNotNullParameter((Object)chunkSourcePath, (String)"chunkSourcePath");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        switch (SharedIndexStorageHolder$WhenMappings.$EnumSwitchMapping$0[option.ordinal()]) {
            case 1: {
                this.mutableStorage.appendChunk(chunkSourcePath, chunkId);
                break;
            }
            case 2: {
                String string2 = "Not supported yet";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final String getStorageId() {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.union((Iterable)this.providedStorages, (Iterable)CollectionsKt.listOf((Object)this.mutableStorage)), (CharSequence)", ", null, null, (int)0, null, (Function1)storageId.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SharedIndexStats getSharedIndexStats() {
        void $this$fold$iv;
        Iterable iterable = this.providedStorages;
        SharedIndexStats initial$iv = this.mutableStorage.getSharedIndexStats();
        boolean $i$f$fold = false;
        SharedIndexStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            SharedIndexStorage sharedIndexStorage = (SharedIndexStorage)element$iv;
            SharedIndexStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus(it.getSharedIndexStats());
        }
        return accumulator$iv;
    }

    public final boolean isCompatibleChunk(@NotNull String chunkId) {
        SharedIndexStorage it$iv;
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        if (it.containsChunk(chunkId) && it.isCompatibleChunk(chunkId)) {
            return true;
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            if (!it.containsChunk(chunkId) || !it.isCompatibleChunk(chunkId)) continue;
            return true;
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            if (!it.containsChunk(chunkId) || !it.isCompatibleChunk(chunkId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        SharedIndexStorage it$iv;
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        try {
            it.close();
        }
        catch (Throwable t) {
            LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            try {
                it.close();
            }
            catch (Throwable t) {
                LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
            }
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            try {
                it.close();
            }
            catch (Throwable t) {
                LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
            }
        }
    }

    public SharedIndexStorageHolder(@NotNull MutableSharedIndexStorage mutableStorage2, @NotNull List<? extends SharedIndexStorage> providedStorages, @NotNull List<ReplaceableSharedIndexStorage> replaceableChunkStorages) {
        Intrinsics.checkNotNullParameter((Object)mutableStorage2, (String)"mutableStorage");
        Intrinsics.checkNotNullParameter(providedStorages, (String)"providedStorages");
        Intrinsics.checkNotNullParameter(replaceableChunkStorages, (String)"replaceableChunkStorages");
        this.mutableStorage = mutableStorage2;
        this.providedStorages = providedStorages;
        this.replaceableChunkStorages = replaceableChunkStorages;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexStorageHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final SharedIndexStorageHolder openStoragesOrReset(@NotNull Runnable corruptionHandler) throws IOException {
        return Companion.openStoragesOrReset(corruptionHandler);
    }

    @JvmStatic
    public static final void deleteMutableStorage() {
        Companion.deleteMutableStorage();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAIN_STORAGE_NAME", "", "MAIN_STORAGE_OLD_NAME", "deleteMutableStorage", "", "openStoragesOrReset", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder;", "corruptionHandler", "Ljava/lang/Runnable;", "intellij.indexing.shared"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SharedIndexStorageHolder openStoragesOrReset(@NotNull Runnable corruptionHandler) throws IOException {
            Intrinsics.checkNotNullParameter((Object)corruptionHandler, (String)"corruptionHandler");
            Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_OLD_NAME);
            Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_NAME);
            SharedIndexMainZipStorage mutableStorage2 = (SharedIndexMainZipStorage)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable(oldStoragePath, newStoragePath){
                final /* synthetic */ Path $oldStoragePath;
                final /* synthetic */ Path $newStoragePath;

                public final SharedIndexMainZipStorage compute() {
                    Path path = this.$oldStoragePath;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"oldStoragePath");
                    Path path2 = this.$newStoragePath;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"newStoragePath");
                    return new SharedIndexMainZipStorage(path, path2, "shared index central storage");
                }
                {
                    this.$oldStoragePath = path;
                    this.$newStoragePath = path2;
                }
            }, (Runnable)new Runnable(corruptionHandler, oldStoragePath, newStoragePath){
                final /* synthetic */ Runnable $corruptionHandler;
                final /* synthetic */ Path $oldStoragePath;
                final /* synthetic */ Path $newStoragePath;

                public final void run() {
                    this.$corruptionHandler.run();
                    if (Files.exists(this.$oldStoragePath, new LinkOption[0])) {
                        FileUtil.delete((Path)this.$oldStoragePath);
                    }
                    if (Files.exists(this.$newStoragePath, new LinkOption[0])) {
                        FileUtil.delete((Path)this.$newStoragePath);
                    }
                }
                {
                    this.$corruptionHandler = runnable;
                    this.$oldStoragePath = path;
                    this.$newStoragePath = path2;
                }
            });
            boolean $i$f$service = false;
            Class<BundledSharedIndexesResolver> serviceClass$iv = BundledSharedIndexesResolver.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            List<SharedIndexStorage> bundledIndexes = ((BundledSharedIndexesResolver)object).openBundledStorages();
            SharedIndexMainZipStorage sharedIndexMainZipStorage = mutableStorage2;
            Intrinsics.checkNotNullExpressionValue((Object)sharedIndexMainZipStorage, (String)"mutableStorage");
            boolean bl = false;
            return new SharedIndexStorageHolder(sharedIndexMainZipStorage, bundledIndexes, new ArrayList());
        }

        @JvmStatic
        public final void deleteMutableStorage() {
            Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_OLD_NAME);
            Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_NAME);
            FileUtil.deleteWithRenaming((File)oldStoragePath.toFile());
            FileUtil.deleteWithRenaming((File)newStoragePath.toFile());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

