/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexProjectIndexingHistoryListener;", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "()V", "onFinishedIndexing", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "intellij.indexing.shared"})
public final class SharedIndexProjectIndexingHistoryListener
implements IndexDiagnosticDumper.ProjectIndexingHistoryListener {
    /*
     * WARNING - void declaration
     */
    public void onFinishedIndexing(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        JsonFileProviderIndexStatistics statistics;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        if (projectIndexingHistory.getTimes().getWasInterrupted()) {
            return;
        }
        Iterable iterable = projectIndexingHistory.getScanningStatistics();
        boolean bl = false;
        int n3 = 0;
        for (Object t : iterable) {
            void statistics2;
            JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)t;
            n2 = n3;
            boolean bl2 = false;
            n = statistics2.getNumberOfFilesForIndexing() + statistics2.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
            n3 = n2 + n;
        }
        int totalNumberOfIndexedFiles = n3;
        if (totalNumberOfIndexedFiles < 100) {
            return;
        }
        Duration indexingDuration = projectIndexingHistory.getTimes().getIndexingDuration();
        if (indexingDuration.compareTo(Duration.ofSeconds(20L)) <= 0) {
            return;
        }
        Iterable iterable2 = projectIndexingHistory.getScanningStatistics();
        boolean bl3 = false;
        int n4 = 0;
        for (Object e : iterable2) {
            JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)e;
            n2 = n4;
            boolean bl4 = false;
            n = statistics.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
            n4 = n2 + n;
        }
        iterable2 = projectIndexingHistory.getProviderStatistics();
        n2 = n4;
        bl3 = false;
        n4 = 0;
        for (Object e : iterable2) {
            statistics = (JsonFileProviderIndexStatistics)e;
            n = n4;
            boolean bl5 = false;
            int n5 = statistics.getTotalNumberOfFilesFullyIndexedByExtensions();
            n4 = n + n5;
        }
        n = n4;
        int totalNumberOfFilesFullyIndexedByInfrastructureExtensions = n2 + n;
        if (totalNumberOfFilesFullyIndexedByInfrastructureExtensions < 100) {
            return;
        }
        int percentage = (int)((double)totalNumberOfFilesFullyIndexedByInfrastructureExtensions / (double)totalNumberOfIndexedFiles * (double)100);
        if (percentage < 20) {
            return;
        }
        String string2 = SharedIndexesBundle.message("eventLog.indexing.completed", NlsMessages.formatDurationApproximate((long)(indexingDuration.toMillis() / (long)1000 * (long)1000)), totalNumberOfFilesFullyIndexedByInfrastructureExtensions, totalNumberOfIndexedFiles, percentage);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SharedIndexesBundle.mess\u2026s,\n      percentage\n    )");
        String messageText2 = string2;
        NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexing Log").createNotification(messageText2, NotificationType.INFORMATION).notify(projectIndexingHistory.getProject());
    }

    public void onStartedIndexing(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        IndexDiagnosticDumper.ProjectIndexingHistoryListener.DefaultImpls.onStartedIndexing((IndexDiagnosticDumper.ProjectIndexingHistoryListener)this, (ProjectIndexingHistory)projectIndexingHistory);
    }
}

