/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashEnumerator;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorages;
import com.intellij.indexing.shared.platform.impl.ChunkManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.IndexedFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk;", "Lcom/intellij/openapi/Disposable;", "chunkRootPath", "Ljava/nio/file/Path;", "indexAttachChunkResult", "Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "(Ljava/nio/file/Path;Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;)V", "attachedProjects", "Ljava/util/HashSet;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/collections/HashSet;", "getAttachedProjects", "()Ljava/util/HashSet;", "hashEnumerators", "", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashEnumerator;", "[Lkotlin/Pair;", "getIndexAttachChunkResult", "()Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "attachProject", "", "project", "detachProject", "dispose", "tryEnumerate", "", "fileContent", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.indexing.shared"})
@VisibleForTesting
public final class SharedIndexChunk
implements Disposable {
    private final Pair<SharedIndexContentHashProvider, SharedIndexContentHashEnumerator>[] hashEnumerators;
    @NotNull
    private final HashSet<Project> attachedProjects;
    @NotNull
    private final AttachChunkResult indexAttachChunkResult;

    /*
     * WARNING - void declaration
     */
    public final int tryEnumerate(@NotNull IndexedFile fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        for (Pair<SharedIndexContentHashProvider, SharedIndexContentHashEnumerator> pair : this.hashEnumerators) {
            byte[] byArray;
            SharedIndexContentHashProvider sharedIndexContentHashProvider = (SharedIndexContentHashProvider)pair.component1();
            SharedIndexContentHashEnumerator hashEnumerator = (SharedIndexContentHashEnumerator)pair.component2();
            try {
                void hashProvider;
                if (hashProvider.computeHash(fileContent) == null) {
                    continue;
                }
            }
            catch (ProcessCanceledException pce) {
                throw (Throwable)pce;
            }
            catch (Exception e) {
                ChunkManagerKt.access$getLOG$p().error((Throwable)e);
                continue;
            }
            byte[] hash = byArray;
            int hashId = hashEnumerator.tryEnumerate(hash);
            if (hashId == 0) continue;
            return hashId;
        }
        return 0;
    }

    public final void attachProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.attachedProjects.add(project);
    }

    public final void detachProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.attachedProjects.remove(project);
    }

    @NotNull
    public final HashSet<Project> getAttachedProjects() {
        return this.attachedProjects;
    }

    public void dispose() {
    }

    @NotNull
    public final AttachChunkResult getIndexAttachChunkResult() {
        return this.indexAttachChunkResult;
    }

    /*
     * WARNING - void declaration
     */
    public SharedIndexChunk(@NotNull Path chunkRootPath, @NotNull AttachChunkResult indexAttachChunkResult) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Intrinsics.checkNotNullParameter((Object)indexAttachChunkResult, (String)"indexAttachChunkResult");
        this.indexAttachChunkResult = indexAttachChunkResult;
        Iterable iterable = SharedIndexHashProviders.getSortedSharedIndexHashingProviders();
        SharedIndexChunk sharedIndexChunk = this;
        boolean $i$f$mapNotNull = false;
        void var5_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            block7: {
                Pair pair2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SharedIndexContentHashProvider it = (SharedIndexContentHashProvider)element$iv$iv;
                boolean bl2 = false;
                try {
                    boolean $i$f$service = false;
                    Class<SharedIndexHashStorages> serviceClass$iv = SharedIndexHashStorages.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    SharedIndexContentHashEnumerator enumerator = ((SharedIndexHashStorages)object).openHashEnumerator(chunkRootPath, it.getInfo(), this);
                    if (enumerator == null) {
                        pair = null;
                        break block7;
                    }
                    pair2 = TuplesKt.to((Object)it, (Object)enumerator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    ChunkManagerKt.access$getLOG$p().warn("Failed to open enumerator for " + it.getInfo().getProviderId() + " from " + chunkRootPath + ". " + t.getMessage(), t);
                    pair2 = null;
                }
                pair = pair2;
            }
            if (pair == null) continue;
            Pair pair3 = pair;
            boolean bl = false;
            boolean bl3 = false;
            Pair it$iv$iv = pair3;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        sharedIndexChunk.hashEnumerators = pairArray;
        boolean bl = false;
        this.attachedProjects = new HashSet();
    }
}

