/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/platform/impl/IndexIdRuleValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "()V", "acceptRuleId", "", "ruleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "validatePlugin", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "intellij.indexing.shared"})
public final class IndexIdRuleValidator
extends CustomValidationRule {
    public boolean acceptRuleId(@Nullable String ruleId) {
        return Intrinsics.areEqual((Object)"index_id", (Object)ruleId);
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (IndexIdRuleValidator.access$isThirdPartyValue$s1023451398(data)) {
            return ValidationResultType.ACCEPTED;
        }
        ID iD = ID.findByName((String)data);
        if (iD == null) {
            return ValidationResultType.REJECTED;
        }
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"ID.findByName<Any, Any>(\u2026dationResultType.REJECTED");
        ID id = iD;
        PluginId pluginId = id.getPluginId();
        if (pluginId != null) {
            return this.validatePlugin(PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId));
        }
        if (PluginManagerCore.isRunningFromSources()) {
            FileBasedIndexExtension extension2 = (FileBasedIndexExtension)FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(new Predicate(data){
                final /* synthetic */ String $data;

                public final boolean test(FileBasedIndexExtension<?, ?> ex) {
                    FileBasedIndexExtension<?, ?> fileBasedIndexExtension = ex;
                    Intrinsics.checkNotNullExpressionValue(fileBasedIndexExtension, (String)"ex");
                    ID iD = fileBasedIndexExtension.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"ex.name");
                    return Intrinsics.areEqual((Object)iD.getName(), (Object)this.$data);
                }
                {
                    this.$data = string2;
                }
            });
            if (extension2 != null) {
                return this.validatePlugin(PluginInfoDetectorKt.getPluginInfo(extension2.getClass()));
            }
            StubIndexExtension stubExtension2 = (StubIndexExtension)StubIndexExtension.EP_NAME.findFirstSafe(new Predicate(data){
                final /* synthetic */ String $data;

                public final boolean test(StubIndexExtension<?, ?> ex) {
                    StubIndexExtension<?, ?> stubIndexExtension = ex;
                    Intrinsics.checkNotNullExpressionValue(stubIndexExtension, (String)"ex");
                    StubIndexKey stubIndexKey = stubIndexExtension.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)stubIndexKey, (String)"ex.key");
                    return Intrinsics.areEqual((Object)stubIndexKey.getName(), (Object)this.$data);
                }
                {
                    this.$data = string2;
                }
            });
            if (stubExtension2 != null) {
                return this.validatePlugin(PluginInfoDetectorKt.getPluginInfo(stubExtension2.getClass()));
            }
        }
        return ValidationResultType.REJECTED;
    }

    private final ValidationResultType validatePlugin(PluginInfo info) {
        if (info.getType() == PluginType.UNKNOWN) {
            return ValidationResultType.REJECTED;
        }
        return info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
    }

    public static final /* synthetic */ boolean access$isThirdPartyValue$s1023451398(String p0) {
        return CustomValidationRule.isThirdPartyValue((String)p0);
    }
}

