/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexAuthHolder;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.impl.SharedIndexesFusCollector;
import com.intellij.indexing.shared.util.DownloadUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a$\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "toSpeedKBytesPerSecond", "", "size", "durationNano", "downloadChunk", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "targetFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
public final class SharedIndexLookupResultKt {
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final boolean downloadChunk(@NotNull SharedIndexLookupResult $this$downloadChunk, @NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
        SharedIndexLookupResult downloadResult;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$downloadChunk, (String)"$this$downloadChunk");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string2 = SharedIndexesBundle.message("downloading.shared.indexes", $this$downloadChunk.getRequest().getPresentableChunkName());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SharedIndexesBundle.mess\u2026est.presentableChunkName)");
        String message = string2;
        if (indicator instanceof SubTaskProgressIndicator) {
            ((SubTaskProgressIndicator)indicator).setText(message);
        } else {
            indicator.setText(message);
            indicator.setText2((String)null);
        }
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadStarted(project, $this$downloadChunk.getRequest().getKind(), $this$downloadChunk.getChunkUniqueId());
        boolean $i$f$service = false;
        Class<SharedIndexAuthHolder> serviceClass$iv = SharedIndexAuthHolder.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        Map<String, String> headers = ((SharedIndexAuthHolder)object2).resolveHeaders($this$downloadChunk.getUrl(), $this$downloadChunk.getRequest(), indicator);
        AtomicLong downloadTime = new AtomicLong(System.nanoTime());
        SharedIndexLookupResult sharedIndexLookupResult = $this$downloadChunk;
        boolean bl = false;
        try {
            Object object3;
            object = Result.Companion;
            SharedIndexLookupResult $this$runCatching = sharedIndexLookupResult;
            boolean bl2 = false;
            try {
                Long l;
                block28: {
                    void request$iv;
                    void LOG$iv;
                    object3 = LOG;
                    SharedIndexLookupRequest sharedIndexLookupRequest = $this$runCatching.getRequest();
                    String url$iv = $this$runCatching.getUrl();
                    boolean $i$f$handleHttpDownloadExceptions = false;
                    try {
                        boolean bl3 = false;
                        l = DownloadUtilKt.downloadUrlWithValidation($this$runCatching.getUrl(), targetFile, $this$runCatching.getSize(), $this$runCatching.getSha256(), headers, $this$runCatching.getCompression(), indicator);
                        break block28;
                    }
                    catch (ConnectException e$iv) {
                        LOG$iv.debug("Cannot connect to the host for " + url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
                    }
                    catch (UnknownHostException e$iv) {
                        LOG$iv.debug("Cannot resolve host for " + url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
                    }
                    catch (SocketTimeoutException e$iv) {
                        if (LOG$iv.isDebugEnabled()) {
                            LOG$iv.warn("Connection expired by timeout at " + url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + '.', (Throwable)e$iv);
                        } else {
                            LOG$iv.warn("Connection expired by timeout at " + url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + '.');
                        }
                    }
                    catch (HttpRequests.HttpStatusException e$iv) {
                        if (e$iv.getStatusCode() < 500) {
                            LOG$iv.debug("No data available for " + url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                        } else {
                            LOG$iv.info("No data available for " + url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                        }
                    }
                    catch (IOException e$iv) {
                        if (LOG$iv.isDebugEnabled()) {
                            StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url$iv).append(" for ").append(request$iv).append(". Error: ");
                            String string3 = e$iv.getMessage();
                            if (string3 == null) {
                                Throwable throwable = e$iv.getCause();
                                string3 = throwable != null ? throwable.getMessage() : null;
                            }
                            LOG$iv.warn(stringBuilder.append(string3 != null ? (Serializable)((Object)string3) : (Serializable)e$iv.getClass()).toString(), (Throwable)e$iv);
                        } else {
                            StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url$iv).append(" for ").append(request$iv).append(". Error: ");
                            String string4 = e$iv.getMessage();
                            if (string4 == null) {
                                Throwable throwable = e$iv.getCause();
                                string4 = throwable != null ? throwable.getMessage() : null;
                            }
                            LOG$iv.warn(stringBuilder.append(string4 != null ? (Serializable)((Object)string4) : (Serializable)e$iv.getClass()).toString());
                        }
                    }
                    catch (Throwable t$iv) {
                        if (t$iv instanceof ControlFlowException) {
                            throw t$iv;
                        }
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url$iv).append(" due ").append(t$iv.getClass()).append(" for ").append(request$iv).append(". Error: ");
                        String string5 = t$iv.getMessage();
                        if (string5 == null) {
                            Throwable throwable = t$iv.getCause();
                            string5 = throwable != null ? throwable.getMessage() : null;
                        }
                        LOG$iv.warn(stringBuilder.append(string5 != null ? (Serializable)((Object)string5) : (Serializable)t$iv.getClass()).toString());
                    }
                    l = null;
                }
                object3 = l;
            }
            finally {
                downloadTime.set(System.nanoTime() - downloadTime.get());
            }
            Object object4 = object3;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)object4);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        sharedIndexLookupResult = object;
        bl = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)sharedIndexLookupResult);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl7 = false;
            boolean bl8 = false;
            Throwable throwable3 = throwable2;
            boolean bl9 = false;
            Throwable it = throwable3;
            boolean bl10 = false;
            if (it instanceof ControlFlowException) {
                throw it;
            }
            LOG.error(it);
        }
        SharedIndexLookupResult sharedIndexLookupResult2 = downloadResult = sharedIndexLookupResult;
        boolean bl11 = false;
        Long sharedIndexSize = (Long)((Object)(Result.isFailure-impl((Object)sharedIndexLookupResult2) ? null : sharedIndexLookupResult2));
        SharedIndexesFusCollector.FinishType finishType2 = Result.isFailure-impl((Object)downloadResult) && Result.exceptionOrNull-impl((Object)downloadResult) instanceof ControlFlowException ? SharedIndexesFusCollector.FinishType.CANCELLED : (Result.isFailure-impl((Object)downloadResult) ? SharedIndexesFusCollector.FinishType.ERROR : (sharedIndexSize == null || sharedIndexSize <= 0L ? SharedIndexesFusCollector.FinishType.ERROR : SharedIndexesFusCollector.FinishType.SUCCESS));
        Long l = sharedIndexSize;
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadFinished(project, finishType2, $this$downloadChunk.getRequest().getKind(), $this$downloadChunk.getChunkUniqueId(), TimeUnit.NANOSECONDS.toMillis(downloadTime.get()), $this$downloadChunk.getSize(), l != null ? l : 0L, SharedIndexLookupResultKt.toSpeedKBytesPerSecond($this$downloadChunk.getSize(), downloadTime.get()));
        String string6 = $this$downloadChunk.getRequest().getKind();
        String string7 = $this$downloadChunk.getChunkUniqueId();
        String string8 = finishType2.name();
        boolean bl12 = false;
        String string9 = string8;
        if (string9 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string10 = string9.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase()");
        Long l2 = sharedIndexSize;
        SharedIndexDiagnostic.INSTANCE.onIndexDownloaded(project, string6, string7, string10, downloadTime.get(), $this$downloadChunk.getSize(), l2 != null ? l2 : 0L);
        return finishType2 == SharedIndexesFusCollector.FinishType.SUCCESS && sharedIndexSize != null && sharedIndexSize > 0L;
    }

    private static final long toSpeedKBytesPerSecond(long size, long durationNano) {
        long millis = TimeUnit.NANOSECONDS.toMillis(durationNano);
        if (millis == 0L) {
            return 0L;
        }
        double kbPerMs = (double)(size / (long)1024) / (double)millis;
        return (long)(kbPerMs * (double)1000);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexLookupResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

