/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecision;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecisionKey;
import com.intellij.indexing.shared.download.IndexDownloadConsentService;
import com.intellij.indexing.shared.download.ShadeIndexDumbModeTrackerTopicListener;
import com.intellij.indexing.shared.download.SharedIndexConfigurable;
import com.intellij.indexing.shared.download.SharedIndexConsentStoreKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadConsentStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.SharedIndexDumbModeTrackingKt;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0014\u0010\u0013\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R(\u0010\u0005\u001a\u001c\u0012\u0018\u0012\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myPendingNotification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "Lcom/intellij/indexing/shared/download/IndexDownloadConsentDecisionKey;", "Lcom/intellij/notification/Notification;", "getProject", "()Lcom/intellij/openapi/project/Project;", "askForMoreDownloads", "", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "dispose", "showNotifications", "NotificationAllowOnce", "NotificationAlwaysDownload", "NotificationConfigure", "NotificationDeny", "intellij.indexing.shared"})
public final class IndexDownloadConsentService
implements Disposable {
    private final AtomicReference<Pair<Set<IndexDownloadConsentDecisionKey>, Notification>> myPendingNotification;
    @NotNull
    private final Project project;

    public void dispose() {
        block0: {
            Pair pair = this.myPendingNotification.getAndSet(null);
            if (pair == null || (pair = (Notification)pair.getSecond()) == null) break block0;
            pair.expire();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void askForMoreDownloads(@NotNull List<? extends SharedIndexSuggestion> suggestions, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$associateByTo$iv$iv;
        Map $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean $i$f$service = false;
        Object serviceClass$iv = SharedIndexDownloadConsentStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + ((Class)serviceClass$iv).getName() + " (classloader=" + ((Class)serviceClass$iv).getClassLoader() + ')');
        }
        SharedIndexDownloadConsentStore consentStore = (SharedIndexDownloadConsentStore)((Object)object);
        serviceClass$iv = suggestions;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
        void var8_11 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            IndexDownloadConsentDecisionKey indexDownloadConsentDecisionKey = SharedIndexConsentStoreKt.toKey((SharedIndexSuggestion)it);
            map.put(indexDownloadConsentDecisionKey, element$iv$iv);
        }
        $this$associateBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        void capacity$iv22 = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var10_15 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var10_15.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(consentStore.decisionFor((IndexDownloadConsentDecisionKey)it.getKey(), project) == IndexDownloadConsentDecision.UNKNOWN)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        boolean bl3 = false;
        SortedMap keysToAsk = MapsKt.toSortedMap((Map)destination$iv$iv2, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                IndexDownloadConsentDecisionKey it = (IndexDownloadConsentDecisionKey)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getKind());
                it = (IndexDownloadConsentDecisionKey)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)((Object)it.getKind());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        });
        Collection collection = keysToAsk.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"keysToAsk.values");
        this.showNotifications(CollectionsKt.toList((Iterable)collection));
    }

    /*
     * WARNING - void declaration
     */
    public final void showNotifications(@NotNull List<? extends SharedIndexSuggestion> suggestions) {
        void $this$mapTo$iv$iv;
        List keysToAsk;
        Object object;
        Collection collection;
        Iterable destination$iv$iv;
        block6: {
            block5: {
                void $this$mapTo$iv$iv2;
                Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
                if (suggestions.isEmpty()) {
                    return;
                }
                Iterable $this$map$iv = suggestions;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    object = SharedIndexConsentStoreKt.toKey((SharedIndexSuggestion)it);
                    collection.add(object);
                }
                keysToAsk = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                if (keysToAsk.isEmpty()) break block5;
                Object object2 = this.myPendingNotification.get();
                if (object2 == null || (object2 = (Set)object2.getFirst()) == null) break block6;
                if (!object2.containsAll(keysToAsk)) break block6;
            }
            return;
        }
        Iterable $this$map$iv = suggestions;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SharedIndexSuggestion bl = (SharedIndexSuggestion)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = it.getSharedIndexConsentNotificationKindPresentableText();
            collection.add(object);
        }
        String string2 = NlsMessages.formatAndList((Collection)CollectionsKt.toList((Iterable)CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv2), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE))));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"NlsMessages.formatAndLis\u2026ENSITIVE_ORDER).toList())");
        String mergedKinds = string2;
        String string3 = SharedIndexesBundle.message("notification.consent.content", mergedKinds);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SharedIndexesBundle.mess\u2026nt.content\", mergedKinds)");
        String notificationContent = string3;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Download Shared Index");
        String string4 = SharedIndexesBundle.message("notification.consent.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"SharedIndexesBundle.mess\u2026ification.consent.title\")");
        Notification notification2 = notificationGroup.createNotification(string4, notificationContent, NotificationType.INFORMATION).setImportant(true).setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST).setDropDownText(SharedIndexesBundle.message("notification.consent.action.moreActions", new Object[0])).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SharedIndexesBundle.message("notification.consent.action.alwaysAllow", new Object[0]), (Runnable)new NotificationAlwaysDownload(this.project, keysToAsk))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SharedIndexesBundle.message("notification.consent.action.allowOnce", new Object[0]), (Runnable)new NotificationAllowOnce(this.project, suggestions))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SharedIndexesBundle.message("notification.consent.action.doNotShow", new Object[0]), (Runnable)new NotificationDeny(keysToAsk))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SharedIndexesBundle.message("notification.consent.action.configure", new Object[0]), (Runnable)new NotificationConfigure(this.project)));
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"NotificationGroupManager\u2026roject)\n        )\n      )");
        Notification notification3 = notification2;
        notification3.whenExpired(new Runnable(this, notification3){
            final /* synthetic */ IndexDownloadConsentService this$0;
            final /* synthetic */ Notification $notification;

            public final void run() {
                IndexDownloadConsentService.access$getMyPendingNotification$p(this.this$0).updateAndGet(new UnaryOperator(this){
                    final /* synthetic */ showNotifications.1 this$0;

                    @Nullable
                    public final Pair<Set<IndexDownloadConsentDecisionKey>, Notification> apply(@Nullable Pair<? extends Set<IndexDownloadConsentDecisionKey>, ? extends Notification> oldNotification) {
                        return oldNotification == null ? null : (Intrinsics.areEqual((Object)((Notification)oldNotification.getSecond()), (Object)this.this$0.$notification) ? null : oldNotification);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = indexDownloadConsentService;
                this.$notification = notification2;
            }
        });
        Notification notification4 = this.myPendingNotification.getAndSet((Pair<Set<IndexDownloadConsentDecisionKey>, Notification>)TuplesKt.to((Object)CollectionsKt.toSet((Iterable)keysToAsk), (Object)notification3));
        if (notification4 != null && (notification4 = (Notification)notification4.getSecond()) != null) {
            notification4.expire();
        }
        notification3.notify(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public IndexDownloadConsentService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myPendingNotification = new AtomicReference<Object>(null);
        this.project.getMessageBus().connect((Disposable)this).subscribe(SharedIndexDumbModeTrackingKt.getShadeIndexDumbModeTrackerTopic(), (Object)new ShadeIndexDumbModeTrackerTopicListener(){

            @Override
            public void onStableDumbModeDetected() {
                block0: {
                    Pair pair = (Pair)myPendingNotification.get();
                    if (pair == null || (pair = (Notification)pair.getSecond()) == null) break block0;
                    Pair pair2 = pair;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair it = pair2;
                    boolean bl3 = false;
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable((Notification)it){
                        final /* synthetic */ Notification $it$inlined;
                        {
                            this.$it$inlined = notification2;
                        }

                        public final void run() {
                            boolean bl = false;
                            this.$it$inlined.hideBalloon();
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                }
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationAlwaysDownload;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "toAllowKeys", "", "Lcom/intellij/indexing/shared/download/IndexDownloadConsentDecisionKey;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "run", "", "intellij.indexing.shared"})
    private static final class NotificationAlwaysDownload
    implements Runnable {
        private final Project project;
        private final List<IndexDownloadConsentDecisionKey> toAllowKeys;

        @Override
        public void run() {
            boolean $i$f$service = false;
            Class serviceClass$iv = SharedIndexDownloadConsentStore.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            ((SharedIndexDownloadConsentStore)((Object)object)).setDecisionFor((Collection<IndexDownloadConsentDecisionKey>)this.toAllowKeys, IndexDownloadConsentDecision.ALLOWED);
            $i$f$service = false;
            serviceClass$iv = SharedIndexDownloadService.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            ((SharedIndexDownloadService)object2).rescanNow(this.project);
        }

        public NotificationAlwaysDownload(@NotNull Project project, @NotNull List<IndexDownloadConsentDecisionKey> toAllowKeys) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(toAllowKeys, (String)"toAllowKeys");
            this.project = project;
            this.toAllowKeys = toAllowKeys;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationAllowOnce;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "run", "", "intellij.indexing.shared"})
    private static final class NotificationAllowOnce
    implements Runnable {
        private final Project project;
        private final List<SharedIndexSuggestion> suggestions;

        @Override
        public void run() {
            boolean $i$f$service = false;
            Class<SharedIndexDownloadService> serviceClass$iv = SharedIndexDownloadService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            ((SharedIndexDownloadService)object).applySuggestions(this.project, this.suggestions);
        }

        public NotificationAllowOnce(@NotNull Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
            this.project = project;
            this.suggestions = suggestions;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationDeny;", "Ljava/lang/Runnable;", "toDenyKeys", "", "Lcom/intellij/indexing/shared/download/IndexDownloadConsentDecisionKey;", "(Ljava/util/List;)V", "run", "", "intellij.indexing.shared"})
    private static final class NotificationDeny
    implements Runnable {
        private final List<IndexDownloadConsentDecisionKey> toDenyKeys;

        @Override
        public void run() {
            boolean $i$f$service = false;
            Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            ((SharedIndexDownloadConsentStore)((Object)object)).setDecisionFor((Collection<IndexDownloadConsentDecisionKey>)this.toDenyKeys, IndexDownloadConsentDecision.DENIED);
        }

        public NotificationDeny(@NotNull List<IndexDownloadConsentDecisionKey> toDenyKeys) {
            Intrinsics.checkNotNullParameter(toDenyKeys, (String)"toDenyKeys");
            this.toDenyKeys = toDenyKeys;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationConfigure;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "run", "", "intellij.indexing.shared"})
    private static final class NotificationConfigure
    implements Runnable {
        private final Project project;

        @Override
        public void run() {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.project, SharedIndexConfigurable.class);
        }

        public NotificationConfigure(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }
}

