/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javahttp.retrofit;

import com.intellij.jam.JamService;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.javahttp.retrofit.RetrofitConstants;
import com.intellij.javahttp.retrofit.jam.RetrofitClient;
import com.intellij.javahttp.retrofit.jam.RetrofitMethod;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javahttp/retrofit/RetrofitModel;", "", "()V", "findClients", "", "Lcom/intellij/javahttp/retrofit/jam/RetrofitClient;", "module", "Lcom/intellij/openapi/module/Module;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getEndpoints", "", "Lcom/intellij/javahttp/retrofit/jam/RetrofitMethod;", "group", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaHttpClients"})
public final class RetrofitModel {
    @NotNull
    public static final RetrofitModel INSTANCE;

    @JvmStatic
    public static final boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"retrofit2.Retrofit");
    }

    @JvmStatic
    public static final boolean isAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"retrofit2.Retrofit");
    }

    @NotNull
    public final List<RetrofitMethod> getEndpoints(@NotNull RetrofitClient group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        JamService jamService = JamService.getJamService((Project)group.getPsiElement().getProject());
        List list = jamService.getAnnotatedMembersList(group.getPsiElement(), RetrofitMethod.Companion.getMETHOD_JAM_KEY(), 10);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jamService.getAnnotatedM\u2026or JamService.CHECK_DEEP)");
        return list;
    }

    @NotNull
    public final Collection<RetrofitClient> findClients(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"module.getModuleWithDepe\u2026sAndLibrariesScope(false)");
        GlobalSearchScope retrofitSearchScope = globalSearchScope;
        if (javaPsiFacade.findClass("retrofit2.Retrofit", retrofitSearchScope) == null) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<PsiClass> hosts = new LinkedHashSet<PsiClass>();
        for (String annotation : RetrofitConstants.INSTANCE.getHTTP_METHOD_ANNOTATIONS()) {
            for (PsiClass psiClass : javaPsiFacade.findClasses(annotation, retrofitSearchScope)) {
                iterator = AnnotatedElementsSearch.searchPsiMethods((PsiClass)psiClass, (SearchScope)((SearchScope)scope)).iterator();
                while (iterator.hasNext()) {
                    PsiMethod method;
                    PsiMethod psiMethod = method = (PsiMethod)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"method");
                    PsiClass containingClass = psiMethod.getContainingClass();
                    if (containingClass == null || !containingClass.isInterface()) continue;
                    hosts.add(containingClass);
                }
            }
        }
        Iterable $this$mapNotNull$iv = hosts;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = iterable;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RetrofitClient retrofitClient;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiClass c = (PsiClass)element$iv$iv;
            boolean bl2 = false;
            if ((RetrofitClient)RetrofitClient.Companion.getMETA().getJamElement((PsiModifierListOwner)c) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            RetrofitClient it$iv$iv = retrofitClient;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private RetrofitModel() {
    }

    static {
        RetrofitModel retrofitModel;
        INSTANCE = retrofitModel = new RetrofitModel();
    }
}

