/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javahttp.okhttp;

import com.intellij.javahttp.okhttp.OkHttpConstants;
import com.intellij.javahttp.okhttp.OkHttpHolder;
import com.intellij.javahttp.okhttp.OkHttpModel;
import com.intellij.javahttp.okhttp.OkHttpUrl;
import com.intellij.javahttp.okhttp.OkHttpUrlBuilder;
import com.intellij.javahttp.okhttp.OkHttpUtils;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.cache.ProjectCacheValueHolder;
import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J,\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001b\u001a\u00020\u000eJ\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u001c\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J$\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u0010'\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00042\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0,H\u0002J\u0016\u0010-\u001a\u00020\u00042\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0002J!\u0010/\u001a\u0002H0\"\u0004\b\u0000\u001002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H002H\u0002\u00a2\u0006\u0002\u00103\u00a8\u00064"}, d2={"Lcom/intellij/javahttp/okhttp/OkHttpModel;", "", "()V", "excludePackages", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "findEndpoints", "", "Lcom/intellij/javahttp/okhttp/OkHttpUrl;", "holderPsi", "Lcom/intellij/psi/PsiElement;", "findHolders", "Lcom/intellij/javahttp/okhttp/OkHttpHolder;", "module", "Lcom/intellij/openapi/module/Module;", "findHoldersUnderProgress", "findUrl", "", "apiMethods", "Lcom/intellij/psi/PsiMethod;", "node", "Lorg/jetbrains/uast/UCallExpression;", "urlCollector", "", "getEndpoints", "group", "getOkHttpScope", "baseScope", "getUastScope", "originalScope", "hasApiClassUsages", "", "query", "Lcom/intellij/microservices/cache/ScopedCacheValueHolder;", "hasClassNameUsage", "className", "", "hasUsages", "searchMethodHolders", "method", "okhttpScope", "holders", "", "unionScope", "scopes", "withProgress", "T", "function", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.javaHttpClients"})
public final class OkHttpModel {
    @NotNull
    public static final OkHttpModel INSTANCE;

    public final boolean hasUsages(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = (ScopedCacheValueHolder)new ProjectCacheValueHolder(project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(project)");
        return this.hasApiClassUsages(scopedCacheValueHolder, globalSearchScope);
    }

    @NotNull
    public final List<OkHttpHolder> findHolders(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return (List)this.withProgress((Function0)new Function0<List<? extends OkHttpHolder>>(module, scope){
            final /* synthetic */ Module $module;
            final /* synthetic */ GlobalSearchScope $scope;

            @NotNull
            public final List<OkHttpHolder> invoke() {
                return OkHttpModel.access$findHoldersUnderProgress(OkHttpModel.INSTANCE, this.$module, this.$scope);
            }
            {
                this.$module = module;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
    }

    @NotNull
    public final List<OkHttpUrl> getEndpoints(@NotNull OkHttpHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PsiElement psiElement = group.getPsiElement();
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        Project project2 = project;
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiElement.containingFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
        if (ProjectScope.getLibrariesScope((Project)project2).contains(virtualFile)) {
            Object object = cachedValuesManager.getCachedValue((UserDataHolder)psiElement, new CachedValueProvider(psiElement, project2){
                final /* synthetic */ PsiElement $psiElement;
                final /* synthetic */ Project $project;

                @Nullable
                public final CachedValueProvider.Result<List<OkHttpUrl>> compute() {
                    return CachedValueProvider.Result.createSingleDependency((Object)OkHttpModel.access$findEndpoints(OkHttpModel.INSTANCE, this.$psiElement), (Object)ProjectRootManager.getInstance((Project)this.$project));
                }
                {
                    this.$psiElement = psiElement;
                    this.$project = project;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cachedValuesManager.getC\u2026stance(project))\n      })");
            return (List)object;
        }
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)psiElement, new CachedValueProvider(psiElement){
            final /* synthetic */ PsiElement $psiElement;

            @Nullable
            public final CachedValueProvider.Result<List<OkHttpUrl>> compute() {
                return CachedValueProvider.Result.createSingleDependency((Object)OkHttpModel.access$findEndpoints(OkHttpModel.INSTANCE, this.$psiElement), (Object)PsiModificationTracker.MODIFICATION_COUNT);
            }
            {
                this.$psiElement = psiElement;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cachedValuesManager.getC\u2026ODIFICATION_COUNT)\n    })");
        return (List)object;
    }

    private final boolean hasApiClassUsages(ScopedCacheValueHolder<?> query, GlobalSearchScope scope) {
        boolean bl;
        block5: {
            List<PsiClass> apiClasses = OkHttpUtils.INSTANCE.getApiClasses(query);
            if (apiClasses.isEmpty()) {
                return false;
            }
            GlobalSearchScope okhttp3Scope = this.getOkHttpScope(query.getProject(), scope);
            if (Intrinsics.areEqual((Object)okhttp3Scope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
                return false;
            }
            Iterable $this$any$iv = apiClasses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiClass clazz = (PsiClass)element$iv;
                    boolean bl2 = false;
                    String className = clazz.getName();
                    if (!(className != null && INSTANCE.hasClassNameUsage(className, query, scope))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasClassNameUsage(String className, ScopedCacheValueHolder<?> query, GlobalSearchScope scope) {
        CacheManager cacheManager = CacheManager.getInstance((Project)query.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"CacheManager.getInstance(query.project)");
        CacheManager cacheManager2 = cacheManager;
        VirtualFile[] virtualFileArray = cacheManager2.getVirtualFilesWithWord(className, (short)1, scope, true);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"cacheManager.getVirtualF\u2026ext.IN_CODE, scope, true)");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        boolean bl = false;
        VirtualFile[] virtualFileArray3 = virtualFileArray2;
        boolean bl2 = false;
        return !(virtualFileArray3.length == 0);
    }

    private final List<OkHttpUrl> findEndpoints(PsiElement holderPsi) {
        UElement uElement = UastContextKt.toUElement((PsiElement)holderPsi);
        if (uElement == null) {
            return CollectionsKt.emptyList();
        }
        UElement parent = uElement;
        Project project = holderPsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holderPsi.project");
        List<PsiMethod> apiMethods = OkHttpUtils.INSTANCE.getUrlApiMethods(project);
        if (apiMethods.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList urls = new ArrayList();
        parent.accept((UastVisitor)new AbstractUastVisitor(apiMethods, urls){
            final /* synthetic */ List $apiMethods;
            final /* synthetic */ ArrayList $urls;

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)UastCallKind.METHOD_CALL)) {
                    OkHttpModel.access$findUrl(OkHttpModel.INSTANCE, this.$apiMethods, node, this.$urls);
                }
                return super.visitCallExpression(node);
            }
            {
                this.$apiMethods = $captured_local_variable$0;
                this.$urls = $captured_local_variable$1;
            }
        });
        return urls;
    }

    private final void findUrl(List<? extends PsiMethod> apiMethods, UCallExpression node, List<OkHttpUrl> urlCollector) {
        Object v6;
        Object object;
        PsiElement sourcePsi;
        Object methodName;
        block10: {
            Object object2 = node.getMethodIdentifier();
            if (object2 == null || (object2 = object2.getName()) == null) {
                return;
            }
            methodName = object2;
            if (!OkHttpConstants.INSTANCE.getURL_RECEIVER_NAMES().contains(methodName)) {
                return;
            }
            if (node.getValueArgumentCount() != 1) {
                return;
            }
            UExpression uExpression = node.getArgumentForParameter(0);
            if (uExpression == null) {
                return;
            }
            UExpression argument = uExpression;
            PsiElement psiElement = argument.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            sourcePsi = psiElement;
            PsiMethod psiMethod = node.resolve();
            if (psiMethod == null) {
                return;
            }
            PsiMethod callExprMethod = psiMethod;
            if (!callExprMethod.hasModifier(JvmModifier.PUBLIC)) {
                return;
            }
            PsiClass psiClass = callExprMethod.getContainingClass();
            if (psiClass == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"callExprMethod.containingClass ?: return");
            PsiClass callTargetClass = psiClass;
            PsiManager psiManager = PsiManager.getInstance((Project)callExprMethod.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(callExprMethod.project)");
            PsiManager psiManager2 = psiManager;
            object = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)apiMethods), (Function1)findUrl.apiClass.1.INSTANCE);
            boolean bl = false;
            Sequence sequence = object;
            boolean bl2 = false;
            for (Object e : sequence) {
                PsiClass it = (PsiClass)e;
                boolean bl3 = false;
                if (!psiManager2.areElementsEquivalent((PsiElement)callTargetClass, (PsiElement)it)) continue;
                v6 = e;
                break block10;
            }
            v6 = null;
        }
        PsiClass apiClass2 = v6;
        if (apiClass2 == null) {
            return;
        }
        object = urlCollector;
        Iterable iterable = OkHttpUrlBuilder.INSTANCE.collectUrls((UElement)node, sourcePsi, (String)methodName);
        boolean bl = false;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
    }

    /*
     * WARNING - void declaration
     */
    private final List<OkHttpHolder> findHoldersUnderProgress(Module module, GlobalSearchScope scope) {
        void $this$mapTo$iv$iv;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        List<PsiMethod> apiMethods = OkHttpUtils.INSTANCE.getUrlApiMethods(project);
        if (apiMethods.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        GlobalSearchScope okhttpScope = this.getOkHttpScope(project2, scope);
        if (Intrinsics.areEqual((Object)okhttpScope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return CollectionsKt.emptyList();
        }
        HashSet holders = new HashSet();
        for (PsiMethod method : apiMethods) {
            this.searchMethodHolders(method, okhttpScope, holders);
        }
        Iterable $this$map$iv = holders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OkHttpHolder okHttpHolder = new OkHttpHolder((PsiElement)it);
            collection.add(okHttpHolder);
        }
        return (List)destination$iv$iv;
    }

    private final void searchMethodHolders(PsiMethod method, GlobalSearchScope okhttpScope, Set<PsiElement> holders) {
        CacheManager cacheManager = CacheManager.getInstance((Project)method.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"CacheManager.getInstance(method.project)");
        CacheManager cacheManager2 = cacheManager;
        Object[] methodIdFiles = cacheManager2.getVirtualFilesWithWord(method.getName(), (short)1, okhttpScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)methodIdFiles, (String)"methodIdFiles");
        Object[] objectArray = methodIdFiles;
        boolean bl = false;
        if (objectArray.length == 0) {
            return;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)method.getProject(), (Collection)ArraysKt.toList((Object[])methodIdFiles));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.filesS\u2026, methodIdFiles.toList())");
        GlobalSearchScope methodIdScope = globalSearchScope;
        Iterator iterator = MethodReferencesSearch.search((PsiMethod)method, (SearchScope)((SearchScope)methodIdScope), (boolean)true).iterator();
        while (iterator.hasNext()) {
            UAnnotated parent;
            UElement uElement;
            PsiReference usage;
            PsiReference psiReference = usage = (PsiReference)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"usage");
            if (UastContextKt.toUElement((PsiElement)psiReference.getElement()) == null) {
                continue;
            }
            if ((UAnnotated)UastUtils.getParentOfType((UElement)uElement, (boolean)true, UClass.class, (Class[])new Class[]{UFile.class}) == null) {
                continue;
            }
            PsiElement javaParent = parent.getJavaPsi();
            if (javaParent != null) {
                holders.add(javaParent);
                continue;
            }
            PsiElement psiElement = usage.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"usage.element");
            PsiFile file = psiElement.getContainingFile();
            if (file == null) continue;
            holders.add((PsiElement)file);
        }
    }

    private final GlobalSearchScope getOkHttpScope(Project project, GlobalSearchScope baseScope) {
        GlobalSearchScope nonBlackListScope = this.excludePackages(project, this.getUastScope(baseScope));
        CacheManager cacheManager = CacheManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"CacheManager.getInstance(project)");
        CacheManager cacheManager2 = cacheManager;
        Object[] containingFiles = cacheManager2.getVirtualFilesWithWord("okhttp3", (short)1, nonBlackListScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)containingFiles, (String)"containingFiles");
        Object[] objectArray = containingFiles;
        boolean bl = false;
        if (objectArray.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"EMPTY_SCOPE");
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)ArraysKt.toList((Object[])containingFiles));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.filesS\u2026containingFiles.toList())");
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope getUastScope(GlobalSearchScope originalScope) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = UastLanguagePlugin.Companion.getInstances();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LanguageFileType languageFileType = it.getLanguage().getAssociatedFileType();
            collection.add(languageFileType);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LanguageFileType[] languageFileTypeArray = thisCollection$iv.toArray(new LanguageFileType[0]);
        if (languageFileTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        LanguageFileType[] fileTypes = languageFileTypeArray;
        FileType[] fileTypeArray = (FileType[])fileTypes;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)originalScope, (FileType[])Arrays.copyOf(fileTypeArray, fileTypeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.getSco\u2026riginalScope, *fileTypes)");
        return globalSearchScope;
    }

    private final GlobalSearchScope unionScope(List<? extends GlobalSearchScope> scopes) {
        GlobalSearchScope globalSearchScope;
        if (scopes.isEmpty()) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope2;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"EMPTY_SCOPE");
        } else {
            GlobalSearchScope globalSearchScope3 = GlobalSearchScope.union((Collection)scopes);
            globalSearchScope = globalSearchScope3;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"GlobalSearchScope.union(scopes)");
        }
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope excludePackages(Project project, GlobalSearchScope scope) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Iterable iterable = OkHttpConstants.INSTANCE.getPACKAGE_SEARCH_BLACK_LIST();
        OkHttpModel okHttpModel = this;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GlobalSearchScope globalSearchScope;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String pkg = (String)element$iv$iv;
            boolean bl2 = false;
            if (javaPsiFacade.findPackage(pkg) != null) {
                PsiPackage psiPackage;
                boolean bl3 = false;
                boolean bl4 = false;
                PsiPackage it = psiPackage;
                boolean bl5 = false;
                globalSearchScope = PackageScope.packageScope((PsiPackage)it, (boolean)false);
            } else {
                globalSearchScope = null;
            }
            if (globalSearchScope == null) continue;
            GlobalSearchScope globalSearchScope2 = globalSearchScope;
            boolean bl6 = false;
            boolean bl7 = false;
            GlobalSearchScope it$iv$iv = globalSearchScope2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        GlobalSearchScope excludedPackagesScope = okHttpModel.unionScope(list);
        GlobalSearchScope globalSearchScope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)excludedPackagesScope));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"scope.intersectWith(Glob\u2026e(excludedPackagesScope))");
        return globalSearchScope;
    }

    private final <T> T withProgress(Function0<? extends T> function) {
        ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
        if (progressIndicator != null && progressIndicator.isRunning()) {
            return (T)function.invoke();
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        Object object = function;
        if (object != null) {
            Function0<? extends T> function0 = object;
            object = new Computable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ Object compute() {
                    return this.function.invoke();
                }
            };
        }
        return (T)progressManager.runProcess((Computable)object, (ProgressIndicator)new EmptyProgressIndicator());
    }

    private OkHttpModel() {
    }

    static {
        OkHttpModel okHttpModel;
        INSTANCE = okHttpModel = new OkHttpModel();
    }

    public static final /* synthetic */ List access$findHoldersUnderProgress(OkHttpModel $this, Module module, GlobalSearchScope scope) {
        return $this.findHoldersUnderProgress(module, scope);
    }

    public static final /* synthetic */ List access$findEndpoints(OkHttpModel $this, PsiElement holderPsi) {
        return $this.findEndpoints(holderPsi);
    }

    public static final /* synthetic */ void access$findUrl(OkHttpModel $this, List apiMethods, UCallExpression node, List urlCollector) {
        $this.findUrl(apiMethods, node, urlCollector);
    }
}

