/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javahttp.okhttp;

import com.intellij.icons.AllIcons;
import com.intellij.javahttp.okhttp.OkHttpHolder;
import com.intellij.javahttp.okhttp.OkHttpModel;
import com.intellij.javahttp.okhttp.OkHttpUrl;
import com.intellij.javahttp.okhttp.OkHttpUtils;
import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uast.UastModificationTracker;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/javahttp/okhttp/OkHttpFramework;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/javahttp/okhttp/OkHttpHolder;", "Lcom/intellij/javahttp/okhttp/OkHttpUrl;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "holdersSearcher", "Lcom/intellij/microservices/cache/SourceTestLibSearcher;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getEndpointData", "", "group", "endpoint", "dataId", "", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "isValidEndpoint", "", "intellij.javaHttpClients"})
public final class OkHttpFramework
implements EndpointsProvider<OkHttpHolder, OkHttpUrl> {
    private final SourceTestLibSearcher<OkHttpHolder> holdersSearcher = new SourceTestLibSearcher("OKHTTP_FILES", (Function2)new Function2<Module, GlobalSearchScope, List<? extends OkHttpHolder>>(OkHttpModel.INSTANCE){

        @NotNull
        public final List<OkHttpHolder> invoke(@NotNull Module p1, @NotNull GlobalSearchScope p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            return ((OkHttpModel)this.receiver).findHolders(p1, p2);
        }
    });
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("OkHttp", "OkHttp", AllIcons.Javaee.WebServiceClient);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_CLIENT_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!OkHttpUtils.isAvailable(project)) {
            return EndpointsProvider.Status.UNAVAILABLE;
        }
        if (OkHttpModel.INSTANCE.hasUsages(project)) {
            return EndpointsProvider.Status.HAS_ENDPOINTS;
        }
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public Iterable<OkHttpHolder> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!OkHttpUtils.isAvailable(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.holdersSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<OkHttpUrl> getEndpoints(@NotNull OkHttpHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return OkHttpModel.INSTANCE.getEndpoints(group);
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull OkHttpHolder group, @NotNull OkHttpUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return (ItemPresentation)new HttpMethodPresentation(endpoint.getUriPresentation(), endpoint.getHttpMethod(), group.getName(), AllIcons.Nodes.PpWeb, null, 16, null);
    }

    @Nullable
    public Object getEndpointData(@NotNull OkHttpHolder group, @NotNull OkHttpUrl endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        ValueKey.BeforeIf beforeIf = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.DOCUMENTATION_ELEMENT).thenGet(new Supplier(endpoint){
            final /* synthetic */ OkHttpUrl $endpoint;

            public final PsiElement get() {
                UElement parent;
                UElement uElement;
                UElement uElement2 = uElement = UastContextKt.toUElement((PsiElement)this.$endpoint.getPsiElement());
                UElement uElement3 = parent = uElement2 != null ? UastUtils.getParentOfType((UElement)uElement2, (boolean)true, UMethod.class, (Class[])new Class[]{UClass.class}) : null;
                return uElement3 != null ? ((UDeclaration)uElement3).getSourcePsi() : null;
            }
            {
                this.$endpoint = okHttpUrl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)beforeIf, (String)"ValueKey.match(dataId)\n \u2026parent?.sourcePsi\n      }");
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)beforeIf, (PsiElement)endpoint.getPsiElement());
    }

    public boolean isValidEndpoint(@NotNull OkHttpHolder group, @NotNull OkHttpUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }
}

