/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.microservices.cache.CacheKeyPair;
import com.intellij.microservices.cache.JamCachedSearchUtils;
import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.microservices.cache.ScopedCacheValueHolders;
import com.intellij.microservices.mq.MQAccessTypes;
import com.intellij.microservices.mq.MQDestination;
import com.intellij.microservices.mq.MQDestinationAnchor;
import com.intellij.microservices.mq.MQType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.semantic.SemKey;
import com.intellij.spring.messaging.jam.mq.SpringJmsListener;
import com.intellij.spring.messaging.jam.mq.SpringJmsListeners;
import com.intellij.spring.messaging.jam.mq.SpringKafkaListener;
import com.intellij.spring.messaging.jam.mq.SpringKafkaListeners;
import com.intellij.spring.messaging.jam.mq.SpringRabbitListener;
import com.intellij.spring.messaging.jam.mq.SpringRabbitListeners;
import com.intellij.spring.messaging.providers.SpringMQUtils;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0007J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0007J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0015H\u0003J\u000e\u0010&\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010'\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010(\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010)\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0015H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/spring/messaging/providers/SpringMQUtils;", "", "()V", "JMS_LISTENERS_CACHE_KEY", "Lcom/intellij/microservices/cache/CacheKeyPair;", "", "Lcom/intellij/spring/messaging/jam/mq/SpringJmsListeners;", "JMS_LISTENER_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringJmsListener;", "KAFKA_LISTENERS_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringKafkaListeners;", "KAFKA_LISTENER_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringKafkaListener;", "RABBIT_LISTENERS_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringRabbitListeners;", "RABBIT_LISTENER_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringRabbitListener;", "collectDestination", "", "element", "Lcom/intellij/jam/JamStringAttributeElement;", "", "mqType", "Lcom/intellij/microservices/mq/MQType;", "collector", "", "Lcom/intellij/microservices/mq/MQDestinationAnchor;", "getJmsListeners", "Lkotlin/sequences/Sequence;", "project", "Lcom/intellij/openapi/project/Project;", "getKafkaListeners", "getRabbitListeners", "hasPlaceholders", "", "mqDestination", "prefix", "suffix", "hasSpringAmqpLibrary", "hasSpringJmsLibrary", "hasSpringKafkaLibrary", "isKnownDestination", "intellij.spring.messaging"})
public final class SpringMQUtils {
    private static final CacheKeyPair<List<SpringJmsListener>> JMS_LISTENER_CACHE_KEY;
    private static final CacheKeyPair<List<SpringJmsListeners>> JMS_LISTENERS_CACHE_KEY;
    private static final CacheKeyPair<List<SpringKafkaListener>> KAFKA_LISTENER_CACHE_KEY;
    private static final CacheKeyPair<List<SpringKafkaListeners>> KAFKA_LISTENERS_CACHE_KEY;
    private static final CacheKeyPair<List<SpringRabbitListener>> RABBIT_LISTENER_CACHE_KEY;
    private static final CacheKeyPair<List<SpringRabbitListeners>> RABBIT_LISTENERS_CACHE_KEY;
    @NotNull
    public static final SpringMQUtils INSTANCE;

    @NotNull
    public final Sequence<SpringRabbitListener> getRabbitListeners(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        SemKey<SpringRabbitListener> semKey = SpringRabbitListener.REPEATABLE_ANNO_JAM_KEY;
        Intrinsics.checkNotNullExpressionValue(semKey, (String)"SpringRabbitListener.REPEATABLE_ANNO_JAM_KEY");
        Sequence listenerSeq = JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder, RABBIT_LISTENER_CACHE_KEY, semKey, (String)"org.springframework.amqp.rabbit.annotation.RabbitListener");
        ScopedCacheValueHolder scopedCacheValueHolder2 = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        JamMethodMeta<SpringRabbitListeners> jamMethodMeta = SpringRabbitListeners.META;
        Intrinsics.checkNotNullExpressionValue(jamMethodMeta, (String)"SpringRabbitListeners.META");
        Sequence listenerContainersSeq2 = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder2, RABBIT_LISTENERS_CACHE_KEY, (JamMemberMeta)((JamMemberMeta)jamMethodMeta), (String)"org.springframework.amqp.rabbit.annotation.RabbitListeners"), (Function1)getRabbitListeners.listenerContainersSeq.1.INSTANCE), (Function1)getRabbitListeners.listenerContainersSeq.2.INSTANCE);
        return SequencesKt.plus((Sequence)listenerSeq, (Sequence)listenerContainersSeq2);
    }

    public final boolean hasSpringAmqpLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.amqp.rabbit.annotation.RabbitListener");
    }

    @NotNull
    public final Sequence<SpringJmsListener> getJmsListeners(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        SemKey<SpringJmsListener> semKey = SpringJmsListener.REPEATABLE_ANNO_JAM_KEY;
        Intrinsics.checkNotNullExpressionValue(semKey, (String)"SpringJmsListener.REPEATABLE_ANNO_JAM_KEY");
        Sequence listenerSeq = JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder, JMS_LISTENER_CACHE_KEY, semKey, (String)"org.springframework.jms.annotation.JmsListener");
        ScopedCacheValueHolder scopedCacheValueHolder2 = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        JamMethodMeta<SpringJmsListeners> jamMethodMeta = SpringJmsListeners.META;
        Intrinsics.checkNotNullExpressionValue(jamMethodMeta, (String)"SpringJmsListeners.META");
        Sequence listenerContainersSeq2 = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder2, JMS_LISTENERS_CACHE_KEY, (JamMemberMeta)((JamMemberMeta)jamMethodMeta), (String)"org.springframework.jms.annotation.JmsListeners"), (Function1)getJmsListeners.listenerContainersSeq.1.INSTANCE), (Function1)getJmsListeners.listenerContainersSeq.2.INSTANCE);
        return SequencesKt.plus((Sequence)listenerSeq, (Sequence)listenerContainersSeq2);
    }

    public final boolean hasSpringJmsLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.jms.annotation.JmsListener");
    }

    @NotNull
    public final Sequence<SpringKafkaListener> getKafkaListeners(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        SemKey<SpringKafkaListener> semKey = SpringKafkaListener.REPEATABLE_ANNO_JAM_KEY;
        Intrinsics.checkNotNullExpressionValue(semKey, (String)"SpringKafkaListener.REPEATABLE_ANNO_JAM_KEY");
        Sequence listenerSeq = JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder, KAFKA_LISTENER_CACHE_KEY, semKey, (String)"org.springframework.kafka.annotation.KafkaListener");
        ScopedCacheValueHolder scopedCacheValueHolder2 = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        JamMethodMeta<SpringKafkaListeners> jamMethodMeta = SpringKafkaListeners.META;
        Intrinsics.checkNotNullExpressionValue(jamMethodMeta, (String)"SpringKafkaListeners.META");
        Sequence listenerContainersSeq2 = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder2, KAFKA_LISTENERS_CACHE_KEY, (JamMemberMeta)((JamMemberMeta)jamMethodMeta), (String)"org.springframework.kafka.annotation.KafkaListeners"), (Function1)getKafkaListeners.listenerContainersSeq.1.INSTANCE), (Function1)getKafkaListeners.listenerContainersSeq.2.INSTANCE);
        return SequencesKt.plus((Sequence)listenerSeq, (Sequence)listenerContainersSeq2);
    }

    public final boolean hasSpringKafkaLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.kafka.annotation.KafkaListener");
    }

    @JvmStatic
    @Contract(value="null -> false", pure=true)
    public static final boolean isKnownDestination(@Nullable String mqDestination) {
        return mqDestination != null && !StringUtil.isEmptyOrSpaces((String)mqDestination) && !SpringMQUtils.hasPlaceholders(mqDestination);
    }

    @JvmStatic
    public static final boolean hasPlaceholders(@NotNull String mqDestination) {
        Intrinsics.checkNotNullParameter((Object)mqDestination, (String)"mqDestination");
        return SpringMQUtils.hasPlaceholders(mqDestination, "${", "}") || SpringMQUtils.hasPlaceholders(mqDestination, "#{", "}");
    }

    @JvmStatic
    private static final boolean hasPlaceholders(String mqDestination, String prefix, String suffix) {
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)mqDestination, (String)prefix, (String)suffix);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"PlaceholderTextRanges.ge\u2026tination, prefix, suffix)");
        Collection collection = set;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @JvmStatic
    public static final void collectDestination(@NotNull JamStringAttributeElement<String> element, @NotNull MQType mqType, @NotNull List<MQDestinationAnchor> collector) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)mqType, (String)"mqType");
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        PsiAnnotationMemberValue psiAnnotationMemberValue = element.getPsiElement();
        if (psiAnnotationMemberValue == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationMemberValue, (String)"element.psiElement ?: return");
        PsiAnnotationMemberValue psi = psiAnnotationMemberValue;
        String string = element.getStringValue();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.stringValue ?: return");
        String name = string;
        if (!SpringMQUtils.isKnownDestination(name)) {
            return;
        }
        collector.add(new MQDestinationAnchor(new MQDestination(mqType, name), (PsiElement)psi, MQAccessTypes.RECEIVE_TYPE));
    }

    private SpringMQUtils() {
    }

    static {
        SpringMQUtils springMQUtils;
        INSTANCE = springMQUtils = new SpringMQUtils();
        JMS_LISTENER_CACHE_KEY = new CacheKeyPair("SPRING_JMS_LISTENER");
        JMS_LISTENERS_CACHE_KEY = new CacheKeyPair("SPRING_JMS_LISTENERS");
        KAFKA_LISTENER_CACHE_KEY = new CacheKeyPair("SPRING_KAFKA_LISTENER");
        KAFKA_LISTENERS_CACHE_KEY = new CacheKeyPair("SPRING_KAFKA_LISTENERS");
        RABBIT_LISTENER_CACHE_KEY = new CacheKeyPair("SPRING_RABBIT_LISTENER");
        RABBIT_LISTENERS_CACHE_KEY = new CacheKeyPair("SPRING_RABBIT_LISTENERS");
    }
}

