/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.DataManager;
import com.intellij.microservices.mq.MQDestinationAnchor;
import com.intellij.microservices.mq.gutters.MQLineMarkerActionsProvider;
import com.intellij.microservices.utils.UsagesNavigationGutterIconBuilder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.messaging.SpringMessagingBundle;
import com.intellij.spring.messaging.SpringMessagingConstants;
import com.intellij.spring.messaging.jam.mq.SpringMQListener;
import com.intellij.spring.messaging.providers.SpringMQLineMarkerProvider;
import com.intellij.spring.messaging.providers.SpringMQUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import icons.MicroservicesIcons;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0014J2\u0010\u0003\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spring/messaging/providers/SpringMQLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "()V", "collectNavigationMarkers", "", "element", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "elements", "", "forNavigation", "", "getIcon", "Ljavax/swing/Icon;", "getId", "", "getName", "Companion", "SpringMqLineMarkerInfo", "intellij.spring.messaging"})
public final class SpringMQLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<MQDestinationAnchor, Collection<PsiElement>> MQ_CONVERTER;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return "SpringMQLineMarkerProvider";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = MicroservicesIcons.Gutter.MessageQueueReceiver;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MicroservicesIcons.Gutter.MessageQueueReceiver");
        return icon;
    }

    @NotNull
    public String getName() {
        return SpringMessagingBundle.message("spring.mq.line.markers.name", new Object[0]);
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        Project project = psiElement2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        Project project2 = project;
        if (!SpringCommonUtils.hasSpringFacets((Project)project2) || !SpringLibraryUtil.hasSpringLibrary((Project)project2)) {
            return;
        }
        if (!(SpringMQUtils.INSTANCE.hasSpringAmqpLibrary(project2) || SpringMQUtils.INSTANCE.hasSpringJmsLibrary(project2) || SpringMQUtils.INSTANCE.hasSpringKafkaLibrary(project2))) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Collection $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UMethod uMethod = (UMethod)UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UMethod.class});
        if (uMethod == null) {
            return;
        }
        UMethod uMethod2 = uMethod;
        PsiMethod psiMethod = uMethod2.getJavaPsi();
        if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor()) {
            return;
        }
        UElement uElement = uMethod2.getUastAnchor();
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return;
        }
        UElement anchor = uElement;
        SemService semService = SemService.getSemService((Project)psiMethod.getProject());
        SmartList relatedMqIds = new SmartList();
        List list = semService.getSemElements(SpringMQListener.SPRING_MQ_LISTENER_KEY, (PsiElement)psiMethod);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"semService.getSemElement\u2026_LISTENER_KEY, psiMethod)");
        List containerJams = list;
        Sequence sequence = containerJams.iterator();
        while (sequence.hasNext()) {
            SpringMQListener containerJam;
            SpringMQListener springMQListener = containerJam = (SpringMQListener)sequence.next();
            Intrinsics.checkNotNullExpressionValue((Object)springMQListener, (String)"containerJam");
            relatedMqIds.addAll((Collection)springMQListener.getMQDestinations());
        }
        Object[] annotations = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)SpringMessagingConstants.SPRING_MQ_ANNOTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)annotations, (String)"annotations");
        sequence = SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])annotations), (Function1)((Function1)new Function1<PsiAnnotation, SpringMQListener>(semService){
            final /* synthetic */ SemService $semService;

            @Nullable
            public final SpringMQListener invoke(PsiAnnotation it) {
                return (SpringMQListener)this.$semService.getSemElement(SpringMQListener.SPRING_MQ_LISTENER_KEY, (PsiElement)it);
            }
            {
                this.$semService = semService;
                super(1);
            }
        })), (Function1)collectNavigationMarkers.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MQDestinationAnchor it = (MQDestinationAnchor)element$iv;
            boolean bl = false;
            relatedMqIds.add((Object)it);
        }
        $this$forEach$iv = (Collection)relatedMqIds;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            Icon icon = MicroservicesIcons.Gutter.MessageQueueReceiver;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MicroservicesIcons.Gutter.MessageQueueReceiver");
            NavigationGutterIconBuilder navigationGutterIconBuilder = UsagesNavigationGutterIconBuilder.Companion.create(icon, MQ_CONVERTER).setTargets((Collection)relatedMqIds);
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"UsagesNavigationGutterIc\u2026.setTargets(relatedMqIds)");
            NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
            if (relatedMqIds.size() == 1) {
                builder.setTooltipText(SpringMessagingBundle.message("spring.mq.line.markers.tooltip.single", ((MQDestinationAnchor)CollectionsKt.first((List)((List)relatedMqIds))).getDestination().getName()));
            } else {
                builder.setTooltipText(SpringMessagingBundle.message("spring.mq.line.markers.tooltip", new Object[0])).setPopupTitle(SpringMessagingBundle.message("spring.mq.line.markers.popupTitle", new Object[0]));
            }
            for (MQLineMarkerActionsProvider actionsProvider : MQLineMarkerActionsProvider.Companion.getInstances()) {
                for (MQLineMarkerActionsProvider.Action action : actionsProvider.getActions((Collection)relatedMqIds, (PsiElement)anchor)) {
                    result.add(new SpringMqLineMarkerInfo(Companion.createExternalContributedActionMarker((PsiElement)anchor, action)));
                }
            }
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo((PsiElement)anchor);
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"builder.createLineMarkerInfo(anchor)");
            result.add(new SpringMqLineMarkerInfo((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo));
        }
    }

    static {
        Companion = new Companion(null);
        MQ_CONVERTER = Companion.MQ_CONVERTER.1.INSTANCE;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/messaging/providers/SpringMQLineMarkerProvider$SpringMqLineMarkerInfo;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "gutter", "(Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;)V", "canMergeWith", "", "info", "Lcom/intellij/codeInsight/daemon/MergeableLineMarkerInfo;", "getElementPresentation", "", "element", "intellij.spring.messaging"})
    private static final class SpringMqLineMarkerInfo
    extends RelatedItemLineMarkerInfo<PsiElement> {
        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            Intrinsics.checkNotNullParameter(info, (String)"info");
            return info instanceof SpringMqLineMarkerInfo;
        }

        @NotNull
        public String getElementPresentation(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = this.getLineMarkerTooltip();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineMarkerTooltip");
            return string;
        }

        public SpringMqLineMarkerInfo(final @NotNull RelatedItemLineMarkerInfo<PsiElement> gutter) {
            Intrinsics.checkNotNullParameter(gutter, (String)"gutter");
            PsiElement psiElement = gutter.getElement();
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement psiElement2 = gutter.getElement();
            Intrinsics.checkNotNull((Object)psiElement2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"gutter.element!!");
            TextRange textRange = psiElement2.getTextRange();
            Icon icon = gutter.getIcon();
            Function function = new Function(){

                public final String fun(PsiElement it) {
                    return gutter.getLineMarkerTooltip();
                }
            };
            GutterIconNavigationHandler gutterIconNavigationHandler = gutter.getNavigationHandler();
            GutterIconRenderer gutterIconRenderer = gutter.createGutterRenderer();
            Intrinsics.checkNotNullExpressionValue((Object)gutterIconRenderer, (String)"gutter.createGutterRenderer()");
            super(psiElement, textRange, icon, function, gutterIconNavigationHandler, gutterIconRenderer.getAlignment(), new NotNullFactory(){

                @NotNull
                public final Collection<? extends GotoRelatedItem> create() {
                    return gutter.createGotoRelatedItems();
                }
            });
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/messaging/providers/SpringMQLineMarkerProvider$Companion;", "", "()V", "MQ_CONVERTER", "Lcom/intellij/util/NotNullFunction;", "Lcom/intellij/microservices/mq/MQDestinationAnchor;", "", "Lcom/intellij/psi/PsiElement;", "createExternalContributedActionMarker", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "anchor", "lineMarkerAction", "Lcom/intellij/microservices/mq/gutters/MQLineMarkerActionsProvider$Action;", "intellij.spring.messaging"})
    public static final class Companion {
        @NotNull
        public final RelatedItemLineMarkerInfo<PsiElement> createExternalContributedActionMarker(@NotNull PsiElement anchor, @NotNull MQLineMarkerActionsProvider.Action lineMarkerAction) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)lineMarkerAction, (String)"lineMarkerAction");
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = NavigationGutterIconBuilder.create((Icon)lineMarkerAction.getLineMarkerIcon()).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(lineMarkerAction.getLineMarkerTooltipText()).setTargets((Collection)CollectionsKt.emptyList()).createLineMarkerInfo(anchor, new GutterIconNavigationHandler(lineMarkerAction){
                final /* synthetic */ MQLineMarkerActionsProvider.Action $lineMarkerAction;

                public final void navigate(MouseEvent e, PsiElement $noName_1) {
                    AnAction anAction = this.$lineMarkerAction.getAction();
                    InputEvent inputEvent = e;
                    DataManager dataManager = DataManager.getInstance();
                    MouseEvent mouseEvent = e;
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"e");
                    anAction.actionPerformed(AnActionEvent.createFromInputEvent((InputEvent)inputEvent, (String)"", null, (DataContext)dataManager.getDataContext(mouseEvent.getComponent())));
                }
                {
                    this.$lineMarkerAction = action;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"NavigationGutterIconBuil\u2026t))\n          )\n        }");
            return relatedItemLineMarkerInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

