/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.trace.samplers.ImmutableSamplingResult;
import java.util.Objects;

public interface SamplingResult {
    public static SamplingResult create(Decision decision) {
        switch (decision) {
            case RECORD_AND_SAMPLE: {
                return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            case RECORD_ONLY: {
                return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
            }
            case DROP: {
                return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
        }
        throw new AssertionError((Object)"unrecognised samplingResult");
    }

    public static SamplingResult create(Decision decision, Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        return attributes.isEmpty() ? SamplingResult.create(decision) : ImmutableSamplingResult.createSamplingResult(decision, attributes);
    }

    public Decision getDecision();

    public Attributes getAttributes();

    default public TraceState getUpdatedTraceState(TraceState parentTraceState) {
        return parentTraceState;
    }

    public static enum Decision {
        DROP,
        RECORD_ONLY,
        RECORD_AND_SAMPLE;

    }
}

