/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.samplers;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.samplers.AutoValue_ImmutableSamplingResult;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
abstract class ImmutableSamplingResult
implements SamplingResult {
    static final SamplingResult EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT = ImmutableSamplingResult.createWithoutAttributes(SamplingResult.Decision.RECORD_AND_SAMPLE);
    static final SamplingResult EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT = ImmutableSamplingResult.createWithoutAttributes(SamplingResult.Decision.DROP);
    static final SamplingResult EMPTY_RECORDED_SAMPLING_RESULT = ImmutableSamplingResult.createWithoutAttributes(SamplingResult.Decision.RECORD_ONLY);
    static final AttributeKey<Double> SAMPLING_PROBABILITY = AttributeKey.doubleKey((String)"sampling.probability");

    ImmutableSamplingResult() {
    }

    static SamplingResult createSamplingResult(SamplingResult.Decision decision, Attributes attributes) {
        return new AutoValue_ImmutableSamplingResult(decision, attributes);
    }

    static SamplingResult createWithProbability(SamplingResult.Decision decision, double probability) {
        return new AutoValue_ImmutableSamplingResult(decision, Attributes.of(SAMPLING_PROBABILITY, (Object)probability));
    }

    private static SamplingResult createWithoutAttributes(SamplingResult.Decision decision) {
        return new AutoValue_ImmutableSamplingResult(decision, Attributes.empty());
    }

    @Override
    public abstract SamplingResult.Decision getDecision();

    @Override
    public abstract Attributes getAttributes();
}

