/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleSpanProcessor
implements SpanProcessor {
    private static final Logger logger = Logger.getLogger(SimpleSpanProcessor.class.getName());
    private final SpanExporter spanExporter;
    private final boolean sampled;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    private SimpleSpanProcessor(SpanExporter spanExporter, boolean sampled) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
        this.sampled = sampled;
    }

    @Override
    public void onStart(Context parentContext, ReadWriteSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (this.sampled && !span.getSpanContext().isSampled()) {
            return;
        }
        try {
            List<SpanData> spans = Collections.singletonList(span.toSpanData());
            CompletableResultCode result = this.spanExporter.export(spans);
            result.whenComplete(() -> {
                if (!result.isSuccess()) {
                    logger.log(Level.FINE, "Exporter failed");
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exporter threw an Exception", e);
        }
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        return this.spanExporter.shutdown();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    public static Builder builder(SpanExporter spanExporter) {
        return new Builder(spanExporter);
    }

    public static final class Builder
    extends ConfigBuilder<Builder> {
        private static final String KEY_SAMPLED = "otel.ssp.export.sampled";
        @VisibleForTesting
        static final boolean DEFAULT_EXPORT_ONLY_SAMPLED = true;
        private final SpanExporter spanExporter;
        private boolean exportOnlySampled = true;

        private Builder(SpanExporter spanExporter) {
            this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
        }

        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            Boolean boolValue = Builder.getBooleanProperty((String)KEY_SAMPLED, (Map)(configMap = namingConvention.normalize(configMap)));
            if (boolValue != null) {
                return this.setExportOnlySampled(boolValue);
            }
            return this;
        }

        public Builder setExportOnlySampled(boolean exportOnlySampled) {
            this.exportOnlySampled = exportOnlySampled;
            return this;
        }

        @VisibleForTesting
        boolean getExportOnlySampled() {
            return this.exportOnlySampled;
        }

        public SimpleSpanProcessor build() {
            return new SimpleSpanProcessor(this.spanExporter, this.exportOnlySampled);
        }
    }
}

