/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.ReadableAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.ImmutableEvent;
import io.opentelemetry.sdk.trace.data.ImmutableLink;
import io.opentelemetry.sdk.trace.data.ImmutableStatus;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanData {
    public String getTraceId();

    public String getSpanId();

    public boolean isSampled();

    public TraceState getTraceState();

    public String getParentSpanId();

    public Resource getResource();

    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public String getName();

    public Span.Kind getKind();

    public long getStartEpochNanos();

    public ReadableAttributes getAttributes();

    public List<Event> getEvents();

    public List<Link> getLinks();

    public Status getStatus();

    public long getEndEpochNanos();

    public boolean hasRemoteParent();

    public boolean hasEnded();

    public int getTotalRecordedEvents();

    public int getTotalRecordedLinks();

    public int getTotalAttributeCount();

    public static interface Status {
        public static Status ok() {
            return ImmutableStatus.OK;
        }

        public static Status unset() {
            return ImmutableStatus.UNSET;
        }

        public static Status error() {
            return ImmutableStatus.ERROR;
        }

        public static Status create(StatusCode code, @Nullable String description) {
            return ImmutableStatus.create(code, description);
        }

        public StatusCode getCanonicalCode();

        @Nullable
        public String getDescription();

        default public boolean isUnset() {
            return StatusCode.UNSET == this.getCanonicalCode();
        }

        default public boolean isOk() {
            return this.isUnset() || StatusCode.OK == this.getCanonicalCode();
        }
    }

    public static interface Event {
        public static Event create(long epochNanos, String name, Attributes attributes) {
            return ImmutableEvent.create(epochNanos, name, attributes);
        }

        public static Event create(long epochNanos, String name, Attributes attributes, int totalAttributeCount) {
            return ImmutableEvent.create(epochNanos, name, attributes, totalAttributeCount);
        }

        public String getName();

        public Attributes getAttributes();

        public long getEpochNanos();

        public int getTotalAttributeCount();

        default public int getDroppedAttributesCount() {
            return this.getTotalAttributeCount() - this.getAttributes().size();
        }
    }

    public static interface Link {
        public static Link create(SpanContext spanContext) {
            return ImmutableLink.create(spanContext);
        }

        public static Link create(SpanContext spanContext, Attributes attributes) {
            return ImmutableLink.create(spanContext, attributes);
        }

        public static Link create(SpanContext spanContext, Attributes attributes, int totalAttributeCount) {
            return ImmutableLink.create(spanContext, attributes, totalAttributeCount);
        }

        public SpanContext getContext();

        public Attributes getAttributes();

        public int getTotalAttributeCount();
    }
}

