/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.AutoValue_ImmutableStatus;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.EnumMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class ImmutableStatus
implements SpanData.Status {
    static final SpanData.Status OK;
    static final SpanData.Status UNSET;
    static final SpanData.Status ERROR;
    static final EnumMap<StatusCode, SpanData.Status> codeToStatus;

    ImmutableStatus() {
    }

    public static SpanData.Status create(StatusCode canonicalCode, @Nullable String description) {
        if (description == null) {
            return codeToStatus.get(canonicalCode);
        }
        return ImmutableStatus.createInternal(canonicalCode, description);
    }

    private static SpanData.Status createInternal(StatusCode canonicalCode, @Nullable String description) {
        return new AutoValue_ImmutableStatus(canonicalCode, description);
    }

    static {
        StatusCode[] codes;
        OK = ImmutableStatus.createInternal(StatusCode.OK, null);
        UNSET = ImmutableStatus.createInternal(StatusCode.UNSET, null);
        ERROR = ImmutableStatus.createInternal(StatusCode.ERROR, null);
        codeToStatus = new EnumMap(StatusCode.class);
        codeToStatus.put(StatusCode.UNSET, SpanData.Status.unset());
        codeToStatus.put(StatusCode.OK, SpanData.Status.ok());
        codeToStatus.put(StatusCode.ERROR, SpanData.Status.error());
        for (StatusCode code : codes = StatusCode.values()) {
            SpanData.Status status = codeToStatus.get(code);
            if (status != null) continue;
            codeToStatus.put(code, ImmutableStatus.createInternal(code, null));
        }
    }
}

