/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.enumerating;

import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.LineEnumeratorFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class KotlinWhenMappingExceptionFilter
extends LineEnumeratorFilter {
    private Label myCurrentLabel = null;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.myCurrentLabel = label;
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (opcode == 187 && type.equals("kotlin/NoWhenBranchMatchedException")) {
            Map<Label, SwitchData> defaultTableSwitchLabels = this.myContext.getBranchData().getDefaultTableSwitchLabels();
            if (defaultTableSwitchLabels == null) {
                return;
            }
            SwitchData switchData = defaultTableSwitchLabels.get(this.myCurrentLabel);
            if (switchData != null) {
                switchData.touch(-1);
            }
        }
    }
}

