/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0005\u001a\u0015\u00108\u001a\u00020\u00022\b\u00109\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010:\u001a\u0010\u00108\u001a\u00020\u00022\b\u00109\u001a\u0004\u0018\u00010;\u001a\u0010\u00108\u001a\u00020\u00022\b\u00109\u001a\u0004\u0018\u00010\t\u001a\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tH\u0001\u001a\u0014\u0010@\u001a\u00020=*\u00020#2\u0006\u0010A\u001a\u00020\tH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0017\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\r*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u0014*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0015\u0010!\u001a\u00020\"*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0015\u0010&\u001a\u00020'*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0015\u0010*\u001a\u00020+*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\"\u0015\u0010.\u001a\u00020\u0002*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0015\u00101\u001a\u000202*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\"\u0017\u00105\u001a\u0004\u0018\u000102*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006B"}, d2={"boolean", "", "Lkotlinx/serialization/json/JsonPrimitive;", "getBoolean", "(Lkotlinx/serialization/json/JsonPrimitive;)Z", "booleanOrNull", "getBooleanOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Boolean;", "contentOrNull", "", "getContentOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/String;", "double", "", "getDouble", "(Lkotlinx/serialization/json/JsonPrimitive;)D", "doubleOrNull", "getDoubleOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Double;", "float", "", "getFloat", "(Lkotlinx/serialization/json/JsonPrimitive;)F", "floatOrNull", "getFloatOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Float;", "int", "", "getInt", "(Lkotlinx/serialization/json/JsonPrimitive;)I", "intOrNull", "getIntOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Integer;", "jsonArray", "Lkotlinx/serialization/json/JsonArray;", "Lkotlinx/serialization/json/JsonElement;", "getJsonArray", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonArray;", "jsonNull", "Lkotlinx/serialization/json/JsonNull;", "getJsonNull", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonNull;", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "getJsonObject", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonObject;", "jsonPrimitive", "getJsonPrimitive", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonPrimitive;", "long", "", "getLong", "(Lkotlinx/serialization/json/JsonPrimitive;)J", "longOrNull", "getLongOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Long;", "JsonPrimitive", "value", "(Ljava/lang/Boolean;)Lkotlinx/serialization/json/JsonPrimitive;", "", "unexpectedJson", "", "key", "expected", "error", "element", "kotlinx-serialization-json"})
public final class JsonElementKt {
    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Boolean value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Number value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, true);
    }

    @NotNull
    public static final JsonPrimitive getJsonPrimitive(@NotNull JsonElement $this$jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonPrimitive, (String)"$this$jsonPrimitive");
        JsonElement jsonElement = $this$jsonPrimitive;
        if (!(jsonElement instanceof JsonPrimitive)) {
            jsonElement = null;
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        if (jsonPrimitive == null) {
            Void void_ = JsonElementKt.error($this$jsonPrimitive, "JsonPrimitive");
            throw new KotlinNothingValueException();
        }
        return jsonPrimitive;
    }

    @NotNull
    public static final JsonObject getJsonObject(@NotNull JsonElement $this$jsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonObject, (String)"$this$jsonObject");
        JsonElement jsonElement = $this$jsonObject;
        if (!(jsonElement instanceof JsonObject)) {
            jsonElement = null;
        }
        JsonObject jsonObject = (JsonObject)jsonElement;
        if (jsonObject == null) {
            Void void_ = JsonElementKt.error($this$jsonObject, "JsonObject");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    @NotNull
    public static final JsonArray getJsonArray(@NotNull JsonElement $this$jsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonArray, (String)"$this$jsonArray");
        JsonElement jsonElement = $this$jsonArray;
        if (!(jsonElement instanceof JsonArray)) {
            jsonElement = null;
        }
        JsonArray jsonArray = (JsonArray)jsonElement;
        if (jsonArray == null) {
            Void void_ = JsonElementKt.error($this$jsonArray, "JsonArray");
            throw new KotlinNothingValueException();
        }
        return jsonArray;
    }

    @NotNull
    public static final JsonNull getJsonNull(@NotNull JsonElement $this$jsonNull) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonNull, (String)"$this$jsonNull");
        JsonElement jsonElement = $this$jsonNull;
        if (!(jsonElement instanceof JsonNull)) {
            jsonElement = null;
        }
        JsonNull jsonNull = (JsonNull)jsonElement;
        if (jsonNull == null) {
            Void void_ = JsonElementKt.error($this$jsonNull, "JsonNull");
            throw new KotlinNothingValueException();
        }
        return jsonNull;
    }

    public static final int getInt(@NotNull JsonPrimitive $this$int) {
        Intrinsics.checkNotNullParameter((Object)$this$int, (String)"$this$int");
        String string = $this$int.getContent();
        boolean bl = false;
        return Integer.parseInt(string);
    }

    @Nullable
    public static final Integer getIntOrNull(@NotNull JsonPrimitive $this$intOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$intOrNull, (String)"$this$intOrNull");
        return StringsKt.toIntOrNull((String)$this$intOrNull.getContent());
    }

    public static final long getLong(@NotNull JsonPrimitive $this$long) {
        Intrinsics.checkNotNullParameter((Object)$this$long, (String)"$this$long");
        String string = $this$long.getContent();
        boolean bl = false;
        return Long.parseLong(string);
    }

    @Nullable
    public static final Long getLongOrNull(@NotNull JsonPrimitive $this$longOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$longOrNull, (String)"$this$longOrNull");
        return StringsKt.toLongOrNull((String)$this$longOrNull.getContent());
    }

    public static final double getDouble(@NotNull JsonPrimitive $this$double) {
        Intrinsics.checkNotNullParameter((Object)$this$double, (String)"$this$double");
        String string = $this$double.getContent();
        boolean bl = false;
        return Double.parseDouble(string);
    }

    @Nullable
    public static final Double getDoubleOrNull(@NotNull JsonPrimitive $this$doubleOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$doubleOrNull, (String)"$this$doubleOrNull");
        return StringsKt.toDoubleOrNull((String)$this$doubleOrNull.getContent());
    }

    public static final float getFloat(@NotNull JsonPrimitive $this$float) {
        Intrinsics.checkNotNullParameter((Object)$this$float, (String)"$this$float");
        String string = $this$float.getContent();
        boolean bl = false;
        return Float.parseFloat(string);
    }

    @Nullable
    public static final Float getFloatOrNull(@NotNull JsonPrimitive $this$floatOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$floatOrNull, (String)"$this$floatOrNull");
        return StringsKt.toFloatOrNull((String)$this$floatOrNull.getContent());
    }

    public static final boolean getBoolean(@NotNull JsonPrimitive $this$boolean) {
        Intrinsics.checkNotNullParameter((Object)$this$boolean, (String)"$this$boolean");
        Boolean bl = StringOpsKt.toBooleanStrictOrNull($this$boolean.getContent());
        if (bl == null) {
            throw (Throwable)new IllegalStateException($this$boolean + " does not represent a Boolean");
        }
        return bl;
    }

    @Nullable
    public static final Boolean getBooleanOrNull(@NotNull JsonPrimitive $this$booleanOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$booleanOrNull, (String)"$this$booleanOrNull");
        return StringOpsKt.toBooleanStrictOrNull($this$booleanOrNull.getContent());
    }

    @Nullable
    public static final String getContentOrNull(@NotNull JsonPrimitive $this$contentOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$contentOrNull, (String)"$this$contentOrNull");
        return $this$contentOrNull instanceof JsonNull ? null : $this$contentOrNull.getContent();
    }

    private static final Void error(JsonElement $this$error, String element) {
        throw (Throwable)new IllegalArgumentException("Element " + Reflection.getOrCreateKotlinClass($this$error.getClass()) + " is not a " + element);
    }

    @PublishedApi
    @NotNull
    public static final Void unexpectedJson(@NotNull String key, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        throw (Throwable)new IllegalArgumentException("Element " + key + " is not a " + expected);
    }
}

