/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.io.FilePermission;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.jetbrains.annotations.NotNull;

public class LocalFileSystem
extends AbstractFileSystem {
    private final String rootFile;

    public LocalFileSystem(@NotNull FileName rootName, String rootFile, FileSystemOptions opts) {
        super(rootName, opts);
        this.rootFile = rootFile;
    }

    @Override
    protected FileObject createFile(@NotNull AbstractFileName name) {
        return new LocalFile(this, this.rootFile, name);
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(DefaultLocalFileProvider.capabilities);
    }

    @Override
    protected File doReplicateFile(FileObject fileObject, FileSelector selector) {
        LocalFile localFile = (LocalFile)fileObject;
        File file = localFile.getLocalFile();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission requiredPerm = new FilePermission(file.getAbsolutePath(), "read");
            sm.checkPermission(requiredPerm);
        }
        return file;
    }
}

