/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandardFileSystemManager
extends DefaultFileSystemManager {
    private static final String CONFIG_RESOURCE = "providers.xml";
    private static final String PLUGIN_CONFIG_RESOURCE = "META-INF/vfs-providers.xml";
    private URL configUri;
    private ClassLoader classLoader;

    public void setConfiguration(String configUri) {
        try {
            this.setConfiguration(new URL(configUri));
        }
        catch (MalformedURLException e) {
            this.getLogger().warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setConfiguration(URL configUri) {
        this.configUri = configUri;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void init() throws FileSystemException {
        DefaultFileReplicator replicator = this.createDefaultFileReplicator();
        this.setReplicator(new PrivilegedFileReplicator(replicator));
        this.setTemporaryFileStore(replicator);
        if (this.configUri == null) {
            URL url = this.getClass().getResource(CONFIG_RESOURCE);
            if (url == null) {
                throw new FileSystemException("vfs.impl/find-config-file.error", (Object)CONFIG_RESOURCE);
            }
            this.configUri = url;
        }
        this.configure(this.configUri);
        this.configurePlugins();
        super.init();
    }

    protected void configurePlugins() throws FileSystemException {
        Enumeration<URL> enumResources;
        ClassLoader cl = this.findClassLoader();
        try {
            enumResources = cl.getResources(PLUGIN_CONFIG_RESOURCE);
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        while (enumResources.hasMoreElements()) {
            URL url = enumResources.nextElement();
            this.configure(url);
        }
    }

    private ClassLoader findClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }

    protected DefaultFileReplicator createDefaultFileReplicator() {
        return new DefaultFileReplicator();
    }

    private void configure(URL configUri) throws FileSystemException {
        InputStream configStream = null;
        try {
            DocumentBuilder builder = this.createDocumentBuilder();
            configStream = configUri.openStream();
            Element config = builder.parse(configStream).getDocumentElement();
            this.configure(config);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/load-config.error", (Object)configUri.toString(), (Throwable)e);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    this.getLogger().warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private void configure(String configUri, InputStream configStream) throws FileSystemException {
        try {
            DocumentBuilder builder = this.createDocumentBuilder();
            Element config = builder.parse(configStream).getDocumentElement();
            this.configure(config);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/load-config.error", (Object)configUri, (Throwable)e);
        }
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        factory.setExpandEntityReferences(true);
        return factory.newDocumentBuilder();
    }

    private void configure(Element config) throws FileSystemException {
        Element provider;
        NodeList providers = config.getElementsByTagName("provider");
        int count = providers.getLength();
        for (int i = 0; i < count; ++i) {
            provider = (Element)providers.item(i);
            this.addProvider(provider, false);
        }
        NodeList defProviders = config.getElementsByTagName("default-provider");
        if (defProviders.getLength() > 0) {
            provider = (Element)defProviders.item(0);
            this.addProvider(provider, true);
        }
    }

    private void addProvider(Element providerDef, boolean isDefault) throws FileSystemException {
        String[] requiredClasses;
        String[] requiredSchemes;
        String classname = providerDef.getAttribute("class-name");
        for (String requiredScheme : requiredSchemes = this.getRequiredSchemes(providerDef)) {
            if (this.hasProvider(requiredScheme)) continue;
            String msg = Messages.getString("vfs.impl/skipping-provider-scheme.debug", classname, requiredScheme);
            VfsLog.debug(this.getLogger(), this.getLogger(), msg);
            return;
        }
        for (String requiredClass : requiredClasses = this.getRequiredClasses(providerDef)) {
            if (this.findClass(requiredClass)) continue;
            String msg = Messages.getString("vfs.impl/skipping-provider.debug", classname, requiredClass);
            VfsLog.debug(this.getLogger(), this.getLogger(), msg);
            return;
        }
        FileProvider provider = (FileProvider)this.createInstance(classname);
        String[] schemas = this.getSchemas(providerDef);
        if (schemas.length > 0) {
            this.addProvider(schemas, provider);
        }
        if (isDefault) {
            this.setDefaultProvider(provider);
        }
    }

    private boolean findClass(String className) {
        try {
            this.findClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String[] getRequiredClasses(Element providerDef) {
        ArrayList<String> classes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        for (int i = 0; i < count; ++i) {
            Element dep = (Element)deps.item(i);
            String className = dep.getAttribute("class-name");
            if (className == null || className.length() <= 0) continue;
            classes.add(className);
        }
        return classes.toArray(new String[0]);
    }

    private String[] getRequiredSchemes(Element providerDef) {
        ArrayList<String> schemes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        for (int i = 0; i < count; ++i) {
            Element dep = (Element)deps.item(i);
            String scheme = dep.getAttribute("scheme");
            if (scheme == null || scheme.length() <= 0) continue;
            schemes.add(scheme);
        }
        return schemes.toArray(new String[0]);
    }

    private String[] getSchemas(Element provider) {
        ArrayList<String> schemas = new ArrayList<String>();
        NodeList schemaElements = provider.getElementsByTagName("scheme");
        int count = schemaElements.getLength();
        for (int i = 0; i < count; ++i) {
            Element scheme = (Element)schemaElements.item(i);
            schemas.add(scheme.getAttribute("name"));
        }
        return schemas.toArray(new String[0]);
    }

    private Object createInstance(String className) throws FileSystemException {
        try {
            Class<?> clazz = this.findClassLoader().loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/create-provider.error", (Object)className, (Throwable)e);
        }
    }
}

