/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.details.diff.load;

import circlet.client.api.GitCommitChange;
import circlet.client.api.GitFile;
import circlet.client.api.ProjectKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.review.details.SpaceReviewChange;
import com.intellij.space.vcs.review.details.diff.load.SpaceDiffLoaderBase;
import git4idea.changes.GitChangeUtils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/space/vcs/review/details/diff/load/SpaceGitDiffLoader;", "Lcom/intellij/space/vcs/review/details/diff/load/SpaceDiffLoaderBase;", "parentLifetime", "Llibraries/coroutines/extra/Lifetime;", "(Llibraries/coroutines/extra/Lifetime;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcirclet/client/api/GitCommitChange;", "Lcom/intellij/space/vcs/review/details/diff/load/SpaceDiffLoaderBase$DiffSides;", "loadDiffSides", "projectKey", "Lcirclet/client/api/ProjectKey;", "spaceReviewChange", "Lcom/intellij/space/vcs/review/details/SpaceReviewChange;", "selectedCommitHashes", "", "", "GitDiffLoadingException", "intellij.space"})
public final class SpaceGitDiffLoader
extends SpaceDiffLoaderBase {
    private final ConcurrentMap<GitCommitChange, SpaceDiffLoaderBase.DiffSides> cache;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected SpaceDiffLoaderBase.DiffSides loadDiffSides(@NotNull ProjectKey projectKey, @NotNull SpaceReviewChange spaceReviewChange, @NotNull List<String> selectedCommitHashes) {
        Change change;
        void leftRangePart;
        Pair pair;
        FilePath it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)spaceReviewChange, (String)"spaceReviewChange");
        Intrinsics.checkNotNullParameter(selectedCommitHashes, (String)"selectedCommitHashes");
        GitCommitChange gitCommitChange = spaceReviewChange.getGitCommitChange();
        SpaceDiffLoaderBase.DiffSides cachedValue = (SpaceDiffLoaderBase.DiffSides)this.cache.get(gitCommitChange);
        if (cachedValue != null) {
            SpaceStatsCounterCollector.DIFF_LOADED.log((Object)SpaceStatsCounterCollector.LoaderType.GIT);
            return cachedValue;
        }
        SpaceRepoInfo spaceRepoInfo = spaceReviewChange.getSpaceRepoInfo();
        if (spaceRepoInfo == null || (spaceRepoInfo = spaceRepoInfo.getRepository()) == null) {
            throw (Throwable)new GitDiffLoadingException("Repository is not mapped");
        }
        SpaceRepoInfo repo = spaceRepoInfo;
        GitFile gitFile = gitCommitChange.getOld();
        String oldRevision = gitFile != null ? gitFile.getCommit() : null;
        GitFile gitFile2 = gitCommitChange.getNew();
        String newRevision = gitFile2 != null ? gitFile2.getCommit() : null;
        boolean bl3 = false;
        Set filePaths = new LinkedHashSet();
        FilePath filePath = spaceReviewChange.getChangeFilePathInfo().getOld();
        if (filePath != null) {
            FilePath filePath2 = filePath;
            bl2 = false;
            bl = false;
            it = filePath2;
            boolean bl4 = false;
            filePaths.add(it);
        }
        FilePath filePath3 = spaceReviewChange.getChangeFilePathInfo().getNew();
        if (filePath3 != null) {
            FilePath filePath4 = filePath3;
            bl2 = false;
            bl = false;
            it = filePath4;
            boolean bl5 = false;
            filePaths.add(it);
        }
        if (oldRevision != null && newRevision != null) {
            pair = TuplesKt.to((Object)oldRevision, (Object)newRevision);
        } else if (oldRevision == null && newRevision != null) {
            pair = TuplesKt.to((Object)(newRevision + '^'), (Object)newRevision);
        } else if (oldRevision != null && newRevision == null) {
            pair = TuplesKt.to((Object)oldRevision, (Object)gitCommitChange.getRevision());
        } else {
            throw (Throwable)new GitDiffLoadingException("Old and new revisions are null");
        }
        Pair pair2 = pair;
        String string = (String)pair2.component1();
        String rightRangePart = (String)pair2.component2();
        Collection collection = GitChangeUtils.getDiff((Project)repo.getProject(), (VirtualFile)repo.getRoot(), (String)leftRangePart, (String)rightRangePart, (Collection)filePaths);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"GitChangeUtils.getDiff(r\u2026ightRangePart, filePaths)");
        Change change2 = change = (Change)CollectionsKt.single((Iterable)collection);
        Intrinsics.checkNotNullExpressionValue((Object)change2, (String)"change");
        ContentRevision contentRevision = change2.getBeforeRevision();
        ContentRevision contentRevision2 = change.getAfterRevision();
        SpaceDiffLoaderBase.DiffSides diffSides = new SpaceDiffLoaderBase.DiffSides(contentRevision != null ? contentRevision.getContent() : null, contentRevision2 != null ? contentRevision2.getContent() : null);
        boolean bl6 = false;
        boolean bl7 = false;
        SpaceDiffLoaderBase.DiffSides it2 = diffSides;
        boolean bl8 = false;
        SpaceStatsCounterCollector.DIFF_LOADED.log((Object)SpaceStatsCounterCollector.LoaderType.GIT);
        this.cache.putIfAbsent(gitCommitChange, it2);
        return diffSides;
    }

    public SpaceGitDiffLoader(@NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        this.cache = new ConcurrentHashMap();
        parentLifetime.add((Function0)new Function0<Unit>(){

            public final void invoke() {
                cache.clear();
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/space/vcs/review/details/diff/load/SpaceGitDiffLoader$GitDiffLoadingException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "intellij.space"})
    public static final class GitDiffLoadingException
    extends Exception {
        public GitDiffLoadingException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

