/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.log;

import circlet.code.api.ExecutionStatus;
import circlet.code.api.ExternalCheckDTO;
import circlet.platform.api.PrimitivesExKt;
import com.intellij.icons.AllIcons;
import com.intellij.space.SpaceIcons;
import com.intellij.space.utils.DateUtilitiesKt;
import com.intellij.space.vcs.log.SpaceExternalCheckRendererKt$WhenMappings;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0015\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0015\u0010\t\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001d\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"getDescription", "", "Lorg/jetbrains/annotations/Nls;", "value", "Lcirclet/code/api/ExternalCheckDTO;", "getIcon", "Ljavax/swing/Icon;", "status", "Lcirclet/code/api/ExecutionStatus;", "getText", "getTime", "timestamp", "", "isInProgress", "", "intellij.space"})
public final class SpaceExternalCheckRendererKt {
    private static final Icon getIcon(ExecutionStatus status) {
        Icon icon;
        switch (SpaceExternalCheckRendererKt$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Icon icon2 = SpaceIcons.Pending;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SpaceIcons.Pending");
                break;
            }
            case 4: {
                Icon icon3 = SpaceIcons.FailedToStart;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SpaceIcons.FailedToStart");
                break;
            }
            case 5: {
                Icon icon4 = SpaceIcons.Running;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"SpaceIcons.Running");
                break;
            }
            case 6: {
                Icon icon5 = SpaceIcons.Failing;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"SpaceIcons.Failing");
                break;
            }
            case 7: {
                Icon icon6 = SpaceIcons.Hanging;
                icon = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"SpaceIcons.Hanging");
                break;
            }
            case 8: {
                Icon icon7 = AllIcons.RunConfigurations.ToolbarPassed;
                icon = icon7;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"AllIcons.RunConfigurations.ToolbarPassed");
                break;
            }
            case 9: {
                Icon icon8 = SpaceIcons.Failed;
                icon = icon8;
                Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"SpaceIcons.Failed");
                break;
            }
            case 10: {
                Icon icon9 = SpaceIcons.Terminated;
                icon = icon9;
                Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"SpaceIcons.Terminated");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    private static final String getText(ExternalCheckDTO value) {
        return value.getTaskName();
    }

    private static final String getDescription(ExternalCheckDTO value) {
        String string = value.getDescription();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private static final String getTime(ExecutionStatus status, long timestamp) {
        return SpaceExternalCheckRendererKt.isInProgress(status) ? DateUtilitiesKt.formatDuration(PrimitivesExKt.getNowMs() - timestamp) : DateUtilitiesKt.formatPrettyDateTime(timestamp);
    }

    private static final boolean isInProgress(ExecutionStatus $this$isInProgress) {
        return $this$isInProgress == ExecutionStatus.RUNNING || $this$isInProgress == ExecutionStatus.FAILING;
    }

    public static final /* synthetic */ Icon access$getIcon(ExecutionStatus status) {
        return SpaceExternalCheckRendererKt.getIcon(status);
    }

    public static final /* synthetic */ String access$getText(ExternalCheckDTO value) {
        return SpaceExternalCheckRendererKt.getText(value);
    }

    public static final /* synthetic */ String access$getTime(ExecutionStatus status, long timestamp) {
        return SpaceExternalCheckRendererKt.getTime(status, timestamp);
    }

    public static final /* synthetic */ String access$getDescription(ExternalCheckDTO value) {
        return SpaceExternalCheckRendererKt.getDescription(value);
    }
}

