/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.vcs.Context;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.log.SpaceCommitId;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.LoadingValue;
import runtime.reactive.LoadingValueKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"getSpaceCommitId", "Lcom/intellij/space/vcs/log/SpaceCommitId;", "Lcom/intellij/vcs/log/ui/table/GraphTableModel;", "row", "", "getSpaceRepo", "Lcom/intellij/space/vcs/SpaceRepoInfo;", "Lcom/intellij/space/vcs/Context;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.space"})
public final class SpaceCommitIdKt {
    @Nullable
    public static final SpaceCommitId getSpaceCommitId(@NotNull GraphTableModel $this$getSpaceCommitId, int row) {
        Intrinsics.checkNotNullParameter((Object)$this$getSpaceCommitId, (String)"$this$getSpaceCommitId");
        VcsLogData vcsLogData = $this$getSpaceCommitId.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"logData");
        Project project = vcsLogData.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"logData.project");
        Context context2 = (Context)LoadingValueKt.unsafeGetOrNull((LoadingValue)((LoadingValue)SpaceProjectContext.Companion.getInstance(project).getContext().getValue()));
        if (context2 == null) {
            return null;
        }
        Context spaceContext = context2;
        CommitId commitId = $this$getSpaceCommitId.getCommitId(row);
        if (commitId == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)commitId, (String)"getCommitId(row) ?: return null");
        CommitId commitId2 = commitId;
        VirtualFile virtualFile = commitId2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commitId.root");
        SpaceRepoInfo spaceRepoInfo = SpaceCommitIdKt.getSpaceRepo(spaceContext, virtualFile);
        if (spaceRepoInfo == null) {
            return null;
        }
        SpaceRepoInfo spaceRepo = spaceRepoInfo;
        SpaceProjectInfo spaceProjectInfo = (SpaceProjectInfo)CollectionsKt.firstOrNull((Iterable)spaceRepo.getProjectInfos());
        if (spaceProjectInfo == null) {
            return null;
        }
        SpaceProjectInfo spaceProject = spaceProjectInfo;
        Hash hash = commitId2.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commitId.hash");
        return new SpaceCommitId(spaceProject, spaceRepo, hash);
    }

    private static final SpaceRepoInfo getSpaceRepo(Context $this$getSpaceRepo, VirtualFile root) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getSpaceRepo.getRepoByUrl().values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SpaceRepoInfo it = (SpaceRepoInfo)element$iv;
                boolean bl = false;
                SpaceRepoInfo spaceRepoInfo = it;
                if (!Intrinsics.areEqual((Object)(spaceRepoInfo != null && (spaceRepoInfo = spaceRepoInfo.getRepository()) != null ? spaceRepoInfo.getRoot() : null), (Object)root)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }
}

