/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.chat.editor;

import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.space.chat.editor.SpaceChatFileType;
import com.intellij.space.chat.model.api.SpaceChatCreationDetails;
import com.intellij.space.editor.SpaceChatComplexPathVirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u0012\b\b\u0001\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/space/chat/editor/SpaceChatFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "sessionId", "", "projectHash", "id", "path", "displayName", "tabTooltip", "chatCreationDetails", "Lcom/intellij/space/chat/model/api/SpaceChatCreationDetails;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/space/chat/model/api/SpaceChatCreationDetails;)V", "getChatCreationDetails", "()Lcom/intellij/space/chat/model/api/SpaceChatCreationDetails;", "getDisplayName", "()Ljava/lang/String;", "getId", "getTabTooltip", "enforcePresentableName", "", "equals", "other", "", "getFileSystem", "Lcom/intellij/space/editor/SpaceChatComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "hashCode", "", "intellij.space"})
public final class SpaceChatFile
extends LightVirtualFile
implements VirtualFilePathWrapper {
    private final String sessionId;
    private final String projectHash;
    @NotNull
    private final String id;
    @NotNull
    private final String displayName;
    @NotNull
    private final String tabTooltip;
    @NotNull
    private final SpaceChatCreationDetails chatCreationDetails;

    @NotNull
    public SpaceChatComplexPathVirtualFileSystem getFileSystem() {
        return SpaceChatComplexPathVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        String string;
        try {
            string = this.getFileSystem().getPath(this.sessionId, this.projectHash, this.id);
        }
        catch (Exception e) {
            String string2 = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            string = string2;
        }
        return string;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentablePath() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.space.chat.editor.SpaceChatFile");
        }
        SpaceChatFile cfr_ignored_0 = (SpaceChatFile)((Object)object2);
        return !(Intrinsics.areEqual((Object)this.id, (Object)((SpaceChatFile)((Object)other)).id) ^ true);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final String getTabTooltip() {
        return this.tabTooltip;
    }

    @NotNull
    public final SpaceChatCreationDetails getChatCreationDetails() {
        return this.chatCreationDetails;
    }

    public SpaceChatFile(@NotNull String sessionId, @NotNull String projectHash, @NlsSafe @NotNull String id, @NlsSafe @NotNull String path, @NlsContexts.TabTitle @NotNull String displayName, @NlsContexts.Tooltip @NotNull String tabTooltip, @NotNull SpaceChatCreationDetails chatCreationDetails2) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)tabTooltip, (String)"tabTooltip");
        Intrinsics.checkNotNullParameter((Object)chatCreationDetails2, (String)"chatCreationDetails");
        super(path, (FileType)SpaceChatFileType.Companion.getInstance(), (CharSequence)"");
        this.sessionId = sessionId;
        this.projectHash = projectHash;
        this.id = id;
        this.displayName = displayName;
        this.tabTooltip = tabTooltip;
        this.chatCreationDetails = chatCreationDetails2;
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
        this.setWritable(false);
    }
}

