/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyProperty;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"getReadPropertyBaseType", "Lcom/intellij/psi/PsiType;", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "getReadPropertyType", "getWritePropertyBaseType", "getWritePropertyType", "box", "context", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "intellij.groovy.psi"})
@JvmName(name="TypeUtils")
public final class TypeUtils {
    @Nullable
    public static final PsiType box(@NotNull PsiType $this$box, @NotNull GroovyPsiElement context) {
        Intrinsics.checkNotNullParameter((Object)$this$box, (String)"$this$box");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!($this$box instanceof PsiPrimitiveType) || Intrinsics.areEqual((Object)$this$box, (Object)PsiType.NULL)) {
            return $this$box;
        }
        String string = ((PsiPrimitiveType)$this$box).getBoxedTypeName();
        if (string == null) {
            String string2 = "This type is not NULL and still doesn't have boxed type name";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"boxedTypeName ?: error(\"\u2026't have boxed type name\")");
        String typeName = string;
        return (PsiType)TypesUtil.createType(typeName, context);
    }

    @Nullable
    public static final PsiType getReadPropertyType(@NotNull GroovyResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiType psiType = TypeUtils.getReadPropertyBaseType(result2);
        if (psiType == null) {
            return null;
        }
        PsiType baseType = psiType;
        return result2.getSubstitutor().substitute(baseType);
    }

    private static final PsiType getReadPropertyBaseType(GroovyResolveResult result2) {
        PsiElement psiElement = result2.getElement();
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"result.element ?: return null");
        PsiElement resolved = psiElement;
        if (resolved instanceof GroovyProperty) {
            return ((GroovyProperty)resolved).getPropertyType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod && (PropertyUtilKt.checkKind((PsiMethod)resolved, PropertyKind.GETTER) || PropertyUtilKt.checkKind((PsiMethod)resolved, PropertyKind.BOOLEAN_GETTER))) {
            return ((PsiMethod)resolved).getReturnType();
        }
        return null;
    }

    @Nullable
    public static final PsiType getWritePropertyType(@NotNull GroovyResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiType psiType = TypeUtils.getWritePropertyBaseType(result2);
        if (psiType == null) {
            return null;
        }
        PsiType baseType = psiType;
        return result2.getSubstitutor().substitute(baseType);
    }

    private static final PsiType getWritePropertyBaseType(GroovyResolveResult result2) {
        PsiElement psiElement = result2.getElement();
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"result.element ?: return null");
        PsiElement resolved = psiElement;
        if (resolved instanceof GroovyProperty) {
            return ((GroovyProperty)resolved).getPropertyType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod && PropertyUtilKt.checkKind((PsiMethod)resolved, PropertyKind.SETTER)) {
            PsiParameterList psiParameterList = ((PsiMethod)resolved).getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"resolved.parameterList");
            PsiParameter psiParameter = psiParameterList.getParameters()[0];
            Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"resolved.parameterList.parameters[0]");
            return psiParameter.getType();
        }
        return null;
    }
}

