/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.resolve.BaseMethodResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.MethodResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.processors.BaseMethodProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f\u0012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/MethodProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/BaseMethodProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind$Hint;", "Lcom/intellij/psi/scope/ElementClassHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/DynamicMembersHint;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "typeArguments", "", "Lcom/intellij/psi/PsiType;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Ljava/util/List;[Lcom/intellij/psi/PsiType;)V", "[Lcom/intellij/psi/PsiType;", "candidate", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "element", "Lcom/intellij/psi/PsiMethod;", "state", "Lcom/intellij/psi/ResolveState;", "shouldProcess", "", "kind", "Lcom/intellij/psi/scope/ElementClassHint$DeclarationKind;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "shouldProcessMethods", "intellij.groovy.psi"})
public final class MethodProcessor
extends BaseMethodProcessor
implements GroovyResolveKind.Hint,
ElementClassHint,
DynamicMembersHint {
    private final PsiElement place;
    private final List<Argument> arguments;
    private final PsiType[] typeArguments;

    @Override
    public boolean shouldProcess(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return kind == GroovyResolveKind.METHOD && this.getAcceptMore();
    }

    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return kind == ElementClassHint.DeclarationKind.METHOD && this.getAcceptMore();
    }

    @Override
    public boolean shouldProcessMethods() {
        return this.getMyCandidates().isEmpty();
    }

    @Override
    @Nullable
    protected GroovyMethodResult candidate(@NotNull PsiMethod element, @NotNull ResolveState state) {
        GroovyMethodResult groovyMethodResult;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!element.hasTypeParameters()) {
            groovyMethodResult = new BaseMethodResolveResult(element, this.place, state, this.arguments);
        } else {
            PsiType[] psiTypeArray = this.typeArguments;
            boolean bl = false;
            if (psiTypeArray.length == 0) {
                groovyMethodResult = new MethodResolveResult(element, this.place, state, this.arguments);
            } else {
                Object object = state.get(PsiSubstitutor.KEY);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"state[PsiSubstitutor.KEY]");
                PsiSubstitutor psiSubstitutor = (PsiSubstitutor)object;
                PsiTypeParameter[] psiTypeParameterArray = element.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"element.typeParameters");
                PsiSubstitutor substitutor2 = InferenceKt.putAll(psiSubstitutor, psiTypeParameterArray, this.typeArguments);
                ResolveState resolveState = state.put(PsiSubstitutor.KEY, (Object)substitutor2);
                Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"state.put(PsiSubstitutor.KEY, substitutor)");
                groovyMethodResult = new BaseMethodResolveResult(element, this.place, resolveState, this.arguments);
            }
        }
        return groovyMethodResult;
    }

    public MethodProcessor(@NotNull String name, @NotNull PsiElement place, @Nullable List<? extends Argument> arguments2, @NotNull PsiType[] typeArguments) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)typeArguments, (String)"typeArguments");
        super(name);
        this.place = place;
        this.arguments = arguments2;
        this.typeArguments = typeArguments;
        this.hint(GroovyResolveKind.HINT_KEY, this);
        this.hint(ElementClassHint.KEY, this);
        this.hint(DynamicMembersHint.KEY, this);
    }
}

