/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.beans.Introspector;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\r\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0003\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u0001*\u0004\u0018\u00010\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0003H\u0000\u00a8\u0006\u0016"}, d2={"checkBaseName", "", "accessorName", "", "prefixLength", "", "getKindByPrefix", "Lcom/intellij/lang/java/beans/PropertyKind;", "getPropertyNameAndKind", "Lkotlin/Pair;", "checkKind", "Lcom/intellij/psi/PsiMethod;", "kind", "getAccessorName", "propertyName", "getPropertyName", "method", "methodName", "getPropertyNameInner", "isBooleanOrBoxed", "Lcom/intellij/psi/PsiType;", "isPropertyName", "intellij.groovy.psi"})
public final class PropertyUtilKt {
    @Nullable
    public static final Pair<String, PropertyKind> getPropertyNameAndKind(@NotNull String accessorName) {
        Intrinsics.checkNotNullParameter((Object)accessorName, (String)"accessorName");
        PropertyKind propertyKind = PropertyUtilKt.getKindByPrefix(accessorName);
        if (propertyKind == null) {
            return null;
        }
        PropertyKind propertyKind2 = propertyKind;
        String string = PropertyUtilKt.getPropertyNameInner(propertyKind2, accessorName);
        if (string == null) {
            return null;
        }
        String propertyName = string;
        return TuplesKt.to((Object)propertyName, (Object)propertyKind2);
    }

    private static final PropertyKind getKindByPrefix(String accessorName) {
        PropertyKind propertyKind;
        block1: {
            PropertyKind[] propertyKindArray = PropertyKind.values();
            boolean bl = false;
            PropertyKind[] propertyKindArray2 = propertyKindArray;
            boolean bl2 = false;
            PropertyKind[] propertyKindArray3 = propertyKindArray2;
            int n = propertyKindArray3.length;
            for (int i = 0; i < n; ++i) {
                PropertyKind propertyKind2;
                PropertyKind it = propertyKind2 = propertyKindArray3[i];
                boolean bl3 = false;
                String string = it.prefix;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.prefix");
                if (!StringsKt.startsWith$default((String)accessorName, (String)string, (boolean)false, (int)2, null)) continue;
                propertyKind = propertyKind2;
                break block1;
            }
            propertyKind = null;
        }
        return propertyKind;
    }

    private static final String getPropertyNameInner(PropertyKind $this$getPropertyNameInner, String accessorName) {
        int prefixLength = $this$getPropertyNameInner.prefix.length();
        if (!PropertyUtilKt.checkBaseName(accessorName, prefixLength)) {
            return null;
        }
        String string = accessorName;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        return Introspector.decapitalize(string3);
    }

    private static final boolean checkBaseName(String accessorName, int prefixLength) {
        if (accessorName.length() <= prefixLength) {
            return false;
        }
        char c = accessorName.charAt(prefixLength);
        boolean bl = false;
        if (Character.isUpperCase(c)) {
            return true;
        }
        if (accessorName.length() <= prefixLength + 1) {
            return false;
        }
        c = accessorName.charAt(prefixLength + 1);
        bl = false;
        return Character.isUpperCase(c);
    }

    public static final boolean checkKind(@NotNull PsiMethod $this$checkKind, @NotNull PropertyKind kind) {
        Intrinsics.checkNotNullParameter((Object)$this$checkKind, (String)"$this$checkKind");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        int expectedParamCount = kind == PropertyKind.SETTER ? 1 : 0;
        PsiParameterList psiParameterList = $this$checkKind.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"parameterList");
        if (psiParameterList.getParametersCount() != expectedParamCount) {
            return false;
        }
        if (kind == PropertyKind.GETTER && Intrinsics.areEqual((Object)$this$checkKind.getReturnType(), (Object)PsiType.VOID)) {
            return false;
        }
        return kind != PropertyKind.BOOLEAN_GETTER || PropertyUtilKt.isBooleanOrBoxed($this$checkKind.getReturnType());
    }

    private static final boolean isBooleanOrBoxed(PsiType $this$isBooleanOrBoxed) {
        return Intrinsics.areEqual((Object)$this$isBooleanOrBoxed, (Object)PsiType.BOOLEAN) || Intrinsics.areEqual((Object)PsiPrimitiveType.getUnboxedType((PsiType)$this$isBooleanOrBoxed), (Object)PsiType.BOOLEAN);
    }

    public static final boolean isPropertyName(@NotNull String $this$isPropertyName) {
        Intrinsics.checkNotNullParameter((Object)$this$isPropertyName, (String)"$this$isPropertyName");
        return GroovyPropertyUtils.isPropertyName($this$isPropertyName);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String getAccessorName(@NotNull PropertyKind $this$getAccessorName, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAccessorName, (String)"$this$getAccessorName");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        if (propertyName.length() <= 1) ** GOTO lbl-1000
        var3_2 = propertyName.charAt(1);
        var4_3 = false;
        if (Character.isUpperCase(var3_2)) {
            v0 = propertyName;
        } else lbl-1000:
        // 2 sources

        {
            v0 = StringsKt.capitalize((String)propertyName);
        }
        suffix = v0;
        return $this$getAccessorName.prefix + suffix;
    }

    @Nullable
    public static final String getPropertyName(@NotNull PropertyKind $this$getPropertyName, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)$this$getPropertyName, (String)"$this$getPropertyName");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String string2 = PropertyUtilKt.getPropertyName($this$getPropertyName, string);
        if (string2 == null) {
            return null;
        }
        String propertyName = string2;
        return PropertyUtilKt.checkKind(method, $this$getPropertyName) ? propertyName : null;
    }

    @Nullable
    public static final String getPropertyName(@NotNull PropertyKind $this$getPropertyName, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)$this$getPropertyName, (String)"$this$getPropertyName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        String string = $this$getPropertyName.prefix;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prefix");
        if (!StringsKt.startsWith$default((String)methodName, (String)string, (boolean)false, (int)2, null)) {
            return null;
        }
        return PropertyUtilKt.getPropertyNameInner($this$getPropertyName, methodName);
    }
}

