/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"checkForPass", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "getCompileStaticAnnotation", "member", "Lcom/intellij/psi/PsiMember;", "isCompileStatic", "e", "Lcom/intellij/psi/PsiElement;", "isCompileStaticInner", "intellij.groovy.psi"})
@JvmName(name="CompileStaticUtil")
public final class CompileStaticUtil {
    public static final boolean isCompileStatic(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiMember containingMember2 = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)e, PsiMember.class, (boolean)false);
        return containingMember2 != null && CompileStaticUtil.isCompileStatic(containingMember2);
    }

    public static final boolean isCompileStatic(@NotNull PsiMember member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        PsiElement psiElement = (PsiElement)member;
        Object object = isCompileStatic.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        Object object2 = CachedValuesManager.getProjectPsiDependentCache((PsiElement)psiElement, (Function)((Function)object));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"CachedValuesManager.getP\u2026, ::isCompileStaticInner)");
        return (Boolean)object2;
    }

    private static final boolean isCompileStaticInner(PsiMember member) {
        PsiAnnotation annotation = CompileStaticUtil.getCompileStaticAnnotation(member);
        if (annotation != null) {
            return CompileStaticUtil.checkForPass(annotation);
        }
        PsiMember enclosingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)member), PsiMember.class, (boolean)true);
        return enclosingMember != null && CompileStaticUtil.isCompileStatic(enclosingMember);
    }

    @Nullable
    public static final PsiAnnotation getCompileStaticAnnotation(@NotNull PsiMember member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        PsiModifierList psiModifierList = member.getModifierList();
        if (psiModifierList == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"member.modifierList ?: return null");
        PsiModifierList list = psiModifierList;
        PsiAnnotation psiAnnotation = list.findAnnotation("groovy.transform.CompileStatic");
        if (psiAnnotation == null) {
            psiAnnotation = list.findAnnotation("groovy.transform.TypeChecked");
        }
        return psiAnnotation;
    }

    public static final boolean checkForPass(@NotNull PsiAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
        return value == null || value instanceof PsiReference && ResolveUtil.isEnumConstant((PsiReference)value, "PASS", "groovy.transform.TypeCheckingMode");
    }

    public static final /* synthetic */ boolean access$isCompileStaticInner(PsiMember member) {
        return CompileStaticUtil.isCompileStaticInner(member);
    }
}

