/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilder;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureSamParameterEnhancer;", "Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/AbstractClosureParameterEnhancer;", "()V", "expectedType", "Lcom/intellij/psi/PsiType;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "fromLiteralConstructorArgument", "list", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "fromMethodCall", "fromReturnStatement", "getClosureParameterType", "index", "", "Companion", "intellij.groovy.psi"})
public class ClosureSamParameterEnhancer
extends AbstractClosureParameterEnhancer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    protected PsiType getClosureParameterType(@NotNull GrFunctionalExpression expression, int index) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiType psiType2 = this.expectedType(expression);
        if (!(psiType2 instanceof PsiClassType)) {
            psiType2 = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType2;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType type2 = psiClassType;
        PsiClassType.ClassResolveResult classResolveResult = type2.resolveGenerics();
        Intrinsics.checkNotNullExpressionValue((Object)classResolveResult, (String)"type.resolveGenerics()");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"result.element ?: return null");
        PsiClass clazz = psiClass;
        PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"result.substitutor");
        PsiSubstitutor substitutor2 = psiSubstitutor;
        MethodSignature methodSignature = SamConversionKt.findSingleAbstractSignature(clazz);
        if (methodSignature == null) {
            return null;
        }
        MethodSignature sam2 = methodSignature;
        Object[] objectArray = sam2.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"sam.parameterTypes");
        PsiType psiType3 = (PsiType)ArraysKt.getOrNull((Object[])objectArray, (int)index);
        if (psiType3 != null) {
            PsiType psiType4 = psiType3;
            boolean bl = false;
            boolean bl2 = false;
            PsiType p1 = psiType4;
            boolean bl3 = false;
            psiType = substitutor2.substitute(p1);
        } else {
            psiType = null;
        }
        return psiType;
    }

    private final PsiType expectedType(GrFunctionalExpression expression) {
        PsiElement parent2 = expression.getParent();
        if (!CompileStaticUtil.isCompileStatic(expression)) {
            if (parent2 instanceof GrSafeCastExpression) {
                GrTypeElement grTypeElement = ((GrSafeCastExpression)parent2).getCastTypeElement();
                return grTypeElement != null ? grTypeElement.getType() : null;
            }
            if (parent2 instanceof GrListOrMap && !((GrListOrMap)parent2).isMap()) {
                return this.fromLiteralConstructorArgument(expression, (GrListOrMap)parent2);
            }
            GrControlFlowOwner controlFlow = ControlFlowUtils.findControlFlowOwner(expression);
            if (controlFlow != null && ControlFlowUtils.isReturnValue(expression, controlFlow)) {
                return this.fromReturnStatement(expression);
            }
        }
        return this.fromMethodCall(expression);
    }

    private final PsiType fromReturnStatement(GrFunctionalExpression expression) {
        PsiElement $this$parentOfType$iv = expression;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        GrMethod grMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrMethod.class, (boolean)true);
        return grMethod != null ? grMethod.getReturnType() : null;
    }

    private final PsiType fromLiteralConstructorArgument(GrFunctionalExpression expression, GrListOrMap list) {
        GroovyConstructorReference groovyConstructorReference = list.getConstructorReference();
        GroovyResolveResult groovyResolveResult = groovyConstructorReference != null ? groovyConstructorReference.advancedResolve() : null;
        if (!(groovyResolveResult instanceof GroovyMethodResult)) {
            groovyResolveResult = null;
        }
        GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
        if (groovyMethodResult == null) {
            return null;
        }
        GroovyMethodResult constructorResult = groovyMethodResult;
        Object object = constructorResult.getCandidate();
        return object != null && (object = object.getArgumentMapping()) != null ? object.expectedType(new ExpressionArgument(expression)) : null;
    }

    private final PsiType fromMethodCall(GrFunctionalExpression expression) {
        GrMethodCall grMethodCall = GrClosureSignatureUtil.findCall(expression);
        if (grMethodCall == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)grMethodCall, (String)"findCall(expression) ?: return null");
        GrMethodCall call = grMethodCall;
        GroovyResolveResult groovyResolveResult = call.advancedResolve();
        if (!(groovyResolveResult instanceof GroovyMethodResult)) {
            groovyResolveResult = null;
        }
        GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
        if (groovyMethodResult == null) {
            return null;
        }
        GroovyMethodResult variant = groovyMethodResult;
        GroovyMethodCandidate groovyMethodCandidate = variant.getCandidate();
        if (groovyMethodCandidate == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)groovyMethodCandidate, (String)"variant.candidate ?: return null");
        GroovyMethodCandidate candidate = groovyMethodCandidate;
        ArgumentMapping<PsiCallParameter> argumentMapping2 = candidate.getArgumentMapping();
        if (argumentMapping2 == null) {
            return null;
        }
        ArgumentMapping<PsiCallParameter> mapping2 = argumentMapping2;
        PsiType psiType = mapping2.expectedType(new ExpressionArgument(expression));
        if (psiType == null) {
            return null;
        }
        PsiType expectedType = psiType;
        PsiSubstitutor substitutor2 = Companion.substitutorIgnoringClosures(call, candidate, variant);
        return substitutor2.substitute(expectedType);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureSamParameterEnhancer$Companion;", "", "()V", "substitutorIgnoringClosures", "Lcom/intellij/psi/PsiSubstitutor;", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "candidate", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCandidate;", "variant", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "intellij.groovy.psi"})
    public static final class Companion {
        @NotNull
        public final PsiSubstitutor substitutorIgnoringClosures(@NotNull GrCall call, @NotNull GroovyMethodCandidate candidate, @NotNull GroovyMethodResult variant) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            PsiElement psiElement = call;
            PsiSubstitutor psiSubstitutor = variant.getContextSubstitutor();
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"variant.contextSubstitutor");
            return new GroovyInferenceSessionBuilder(psiElement, candidate, psiSubstitutor).skipClosureIn(call).resolveMode(false).build().inferSubst();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

