/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.DfaCacheConsistencyKt;

class TypeDfaState {
    private final Map<VariableDescriptor, DFAType> myVarTypes;
    private final Set<VariableDescriptor> myProhibitedCachingVars;

    TypeDfaState() {
        this.myVarTypes = new HashMap<VariableDescriptor, DFAType>();
        this.myProhibitedCachingVars = new HashSet<VariableDescriptor>();
    }

    TypeDfaState(TypeDfaState another) {
        this.myVarTypes = new HashMap<VariableDescriptor, DFAType>(another.myVarTypes);
        this.myProhibitedCachingVars = new HashSet<VariableDescriptor>(another.myProhibitedCachingVars);
    }

    Map<VariableDescriptor, DFAType> getVarTypes() {
        return this.myVarTypes;
    }

    TypeDfaState mergeWith(TypeDfaState another) {
        if (another.myVarTypes.isEmpty()) {
            return this;
        }
        TypeDfaState.checkDfaStatesConsistency(this, another);
        TypeDfaState state = new TypeDfaState(this);
        Map retainedDescriptors = ContainerUtil.filter(another.myVarTypes, descriptor -> !another.myProhibitedCachingVars.contains(descriptor));
        state.myVarTypes.putAll(retainedDescriptors);
        return state;
    }

    private static void checkDfaStatesConsistency(@NotNull TypeDfaState state, @NotNull TypeDfaState another) {
        if (state == null) {
            TypeDfaState.$$$reportNull$$$0(0);
        }
        if (another == null) {
            TypeDfaState.$$$reportNull$$$0(1);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() || ApplicationManagerEx.isInStressTest() || DfaCacheConsistencyKt.mustSkipConsistencyCheck()) {
            return;
        }
        Map anotherTypes = ContainerUtil.filter(another.myVarTypes, descriptor -> !another.myProhibitedCachingVars.contains(descriptor));
        Collection commonDescriptors = ContainerUtil.intersection(state.myVarTypes.keySet(), anotherTypes.keySet());
        Map differingEntries = ContainerUtil.filter((Map)ContainerUtil.diff(state.myVarTypes, (Map)anotherTypes), commonDescriptors::contains);
        if (!differingEntries.isEmpty()) {
            throw new IllegalStateException("Attempt to cache different types: " + differingEntries.toString());
        }
    }

    void joinState(TypeDfaState another, PsiManager manager) {
        this.myVarTypes.keySet().removeAll(another.myProhibitedCachingVars);
        for (Map.Entry<VariableDescriptor, DFAType> entry : another.myVarTypes.entrySet()) {
            VariableDescriptor descriptor = entry.getKey();
            if (this.myProhibitedCachingVars.contains(descriptor)) continue;
            DFAType t1 = entry.getValue();
            if (this.myVarTypes.containsKey(descriptor)) {
                DFAType t2 = this.myVarTypes.get(descriptor);
                if (t1 != null && t2 != null) {
                    this.myVarTypes.put(descriptor, DFAType.create(t1, t2, manager));
                    continue;
                }
                this.myVarTypes.put(descriptor, null);
                continue;
            }
            if (t1 == null || t1.getFlushingType().equals(PsiType.NULL)) continue;
            DFAType dfaType = DFAType.create(null);
            this.myVarTypes.put(descriptor, dfaType.addFlushingType(t1.getFlushingType(), manager));
        }
        this.myProhibitedCachingVars.addAll(another.myProhibitedCachingVars);
    }

    boolean contentsEqual(TypeDfaState another) {
        return this.myVarTypes.equals(another.myVarTypes) && this.myProhibitedCachingVars.equals(another.myProhibitedCachingVars);
    }

    @Nullable
    DFAType getVariableType(VariableDescriptor descriptor) {
        return this.myVarTypes.get(descriptor);
    }

    @Contract(value="_ -> new")
    @NotNull
    DFAType getOrCreateVariableType(VariableDescriptor descriptor) {
        DFAType result2 = this.getVariableType(descriptor);
        DFAType dFAType = result2 == null ? DFAType.create(null) : result2.copy();
        if (dFAType == null) {
            TypeDfaState.$$$reportNull$$$0(2);
        }
        return dFAType;
    }

    Map<VariableDescriptor, DFAType> getBindings() {
        return new HashMap<VariableDescriptor, DFAType>(this.myVarTypes);
    }

    void putType(VariableDescriptor descriptor, @Nullable DFAType type2) {
        this.myVarTypes.put(descriptor, type2);
    }

    @NonNls
    public String toString() {
        String evicted = this.myProhibitedCachingVars.isEmpty() ? "" : " (caching prohibited: " + this.myProhibitedCachingVars.toString() + ")";
        return this.myVarTypes.toString() + evicted;
    }

    public boolean containsVariable(@NotNull VariableDescriptor descriptor) {
        if (descriptor == null) {
            TypeDfaState.$$$reportNull$$$0(3);
        }
        return this.myVarTypes.containsKey(descriptor);
    }

    public void removeBinding(@NotNull VariableDescriptor descriptor) {
        if (descriptor == null) {
            TypeDfaState.$$$reportNull$$$0(4);
        }
        this.myProhibitedCachingVars.add(descriptor);
        this.myVarTypes.remove(descriptor);
    }

    public void restoreBinding(@NotNull VariableDescriptor descriptor) {
        if (descriptor == null) {
            TypeDfaState.$$$reportNull$$$0(5);
        }
        this.myProhibitedCachingVars.remove(descriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaState";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateVariableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDfaStatesConsistency";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeBinding";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restoreBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

