/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LazyKt;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.FunctionalExpressionFlowUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.DFAFlowInfo;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InitialTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.SharedVariableInferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.util.GraphKt;

final class InferenceCache {
    @NotNull
    private final GrControlFlowOwner myScope;
    private final Instruction[] myFlow;
    private final Map<PsiElement, List<Instruction>> myFromByElements;
    private final Lazy<Object2IntMap<VariableDescriptor>> myVarIndexes;
    private final Lazy<List<DefinitionMap>> myDefinitionMaps;
    private final AtomicReference<List<TypeDfaState>> myVarTypes;
    private final SharedVariableInferenceCache mySharedVariableInferenceCache;
    private final Set<Instruction> myTooComplexInstructions;

    InferenceCache(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            InferenceCache.$$$reportNull$$$0(0);
        }
        this.myTooComplexInstructions = ContainerUtil.newConcurrentSet();
        this.myScope = scope;
        this.myFlow = scope.getControlFlow();
        this.myVarIndexes = LazyKt.lazyPub(() -> UtilKt.getVarIndexes(this.myScope));
        this.myDefinitionMaps = LazyKt.lazyPub(() -> TypeInferenceHelper.getDefUseMaps(this.myFlow, (Object2IntMap<VariableDescriptor>)((Object2IntMap)this.myVarIndexes.getValue())));
        this.mySharedVariableInferenceCache = new SharedVariableInferenceCache(scope);
        this.myFromByElements = Arrays.stream(this.myFlow).filter(it -> it.getElement() != null).collect(Collectors.groupingBy(Instruction::getElement));
        ArrayList<TypeDfaState> noTypes = new ArrayList<TypeDfaState>();
        for (int i = 0; i < this.myFlow.length; ++i) {
            noTypes.add(new TypeDfaState());
        }
        this.myVarTypes = new AtomicReference(noTypes);
    }

    boolean isTooComplexToAnalyze() {
        return this.myDefinitionMaps.getValue() == null;
    }

    @Nullable
    PsiType getInferredType(@NotNull VariableDescriptor descriptor, @NotNull Instruction instruction, boolean mixinOnly) {
        if (descriptor == null) {
            InferenceCache.$$$reportNull$$$0(1);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(2);
        }
        return this.getInferredType(descriptor, instruction, mixinOnly, Collections.emptyMap());
    }

    @Nullable
    PsiType getInferredType(@NotNull VariableDescriptor descriptor, @NotNull Instruction instruction, boolean mixinOnly, @NotNull Map<VariableDescriptor, DFAType> initialState) {
        DFAType dfaType;
        if (descriptor == null) {
            InferenceCache.$$$reportNull$$$0(3);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(4);
        }
        if (initialState == null) {
            InferenceCache.$$$reportNull$$$0(5);
        }
        if (this.myTooComplexInstructions.contains(instruction)) {
            return null;
        }
        List definitionMaps = (List)this.myDefinitionMaps.getValue();
        if (definitionMaps == null || !this.isDescriptorAvailable(descriptor)) {
            return null;
        }
        TypeDfaState cache2 = this.myVarTypes.get().get(instruction.num());
        if (!cache2.containsVariable(descriptor)) {
            Predicate<Instruction> mixinPredicate = mixinOnly ? e -> e instanceof MixinTypeInstruction : e -> true;
            DFAFlowInfo flowInfo = this.collectFlowInfo(definitionMaps, instruction, descriptor, mixinPredicate);
            List<TypeDfaState> dfaResult = this.performTypeDfa(this.myScope, this.myFlow, flowInfo, initialState);
            if (dfaResult == null) {
                this.myTooComplexInstructions.addAll(flowInfo.getInterestingInstructions());
            } else if (TypeInferenceHelper.getCurrentContext().isInferenceResultsCachingAllowed()) {
                Set<Instruction> stored = flowInfo.getInterestingInstructions();
                stored.add(instruction);
                this.cacheDfaResult(dfaResult, stored);
            } else {
                DFAType dfaType2 = dfaResult.get(instruction.num()).getVariableType(descriptor);
                return dfaType2 == null ? null : dfaType2.getResultType(this.myScope.getManager());
            }
        }
        return (dfaType = this.getCachedInferredType(descriptor, instruction)) == null ? null : dfaType.getResultType(this.myScope.getManager());
    }

    @Nullable
    private List<TypeDfaState> performTypeDfa(@NotNull GrControlFlowOwner owner, Instruction @NotNull [] flow, @NotNull DFAFlowInfo flowInfo, @NotNull Map<VariableDescriptor, DFAType> initialTypes) {
        if (owner == null) {
            InferenceCache.$$$reportNull$$$0(6);
        }
        if (flowInfo == null) {
            InferenceCache.$$$reportNull$$$0(7);
        }
        if (initialTypes == null) {
            InferenceCache.$$$reportNull$$$0(8);
        }
        if (flow == null) {
            InferenceCache.$$$reportNull$$$0(9);
        }
        TypeDfaInstance dfaInstance = new TypeDfaInstance(flow, flowInfo, this, owner.getManager());
        TypeDfaState initialState = this.computeInitialState(flowInfo, new InitialTypeProvider(owner, initialTypes));
        TypesSemilattice semilattice = new TypesSemilattice(owner.getManager(), initialState);
        return new DFAEngine<TypeDfaState>(flow, dfaInstance, semilattice).performDFAWithTimeout();
    }

    private TypeDfaState computeInitialState(@NotNull DFAFlowInfo flowInfo, @NotNull InitialTypeProvider provider2) {
        if (flowInfo == null) {
            InferenceCache.$$$reportNull$$$0(10);
        }
        if (provider2 == null) {
            InferenceCache.$$$reportNull$$$0(11);
        }
        TypeDfaState state = new TypeDfaState();
        Set<VariableDescriptor> descriptors = ControlFlowBuilderUtil.getDescriptorsWithoutWrites(this.myFlow);
        for (VariableDescriptor descriptor : descriptors) {
            DFAType initialType;
            if (!flowInfo.getInterestingDescriptors().contains(descriptor) || (initialType = provider2.initialType(descriptor)) == null) continue;
            state.putType(descriptor, initialType);
        }
        return state;
    }

    @Nullable
    DFAType getCachedInferredType(@NotNull VariableDescriptor descriptor, @NotNull Instruction instruction) {
        if (descriptor == null) {
            InferenceCache.$$$reportNull$$$0(12);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(13);
        }
        return this.myVarTypes.get().get(instruction.num()).getVariableType(descriptor);
    }

    private DFAFlowInfo collectFlowInfo(@NotNull List<DefinitionMap> definitionMaps, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor, @NotNull Predicate<? super Instruction> predicate2) {
        if (definitionMaps == null) {
            InferenceCache.$$$reportNull$$$0(14);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(15);
        }
        if (descriptor == null) {
            InferenceCache.$$$reportNull$$$0(16);
        }
        if (predicate2 == null) {
            InferenceCache.$$$reportNull$$$0(17);
        }
        LinkedHashMap<Pair, Set<Pair<Instruction, VariableDescriptor>>> interesting = new LinkedHashMap<Pair, Set<Pair<Instruction, VariableDescriptor>>>();
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(Pair.create((Object)instruction, (Object)descriptor));
        LinkedHashSet<Instruction> dependentOnSharedVariables = new LinkedHashSet<Instruction>();
        List<Object> closureInstructions = FunctionalExpressionFlowUtil.isNestedFlowProcessingAllowed() ? this.getClosureInstructionsWithForeigns() : Collections.emptyList();
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            if (interesting.containsKey(pair)) continue;
            Set<Pair<Instruction, VariableDescriptor>> dependencies = this.findDependencies(definitionMaps, closureInstructions, (Instruction)pair.first, (VariableDescriptor)pair.second);
            interesting.put(pair, dependencies);
            if (dependencies.stream().anyMatch(it -> TypeInferenceHelper.isSharedVariable((VariableDescriptor)it.second))) {
                dependentOnSharedVariables.add((Instruction)pair.first);
            }
            dependencies.forEach(queue::addLast);
        }
        Set interestingInstructions = interesting.keySet().stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        Set acyclicInstructions = GraphKt.findNodesOutsideCycles(GraphKt.mapGraph(interesting)).stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        Set interestingDescriptors = interesting.keySet().stream().map(it -> (VariableDescriptor)it.getSecond()).collect(Collectors.toSet());
        return new DFAFlowInfo(interestingInstructions, acyclicInstructions, interestingDescriptors, dependentOnSharedVariables);
    }

    private List<Pair<Instruction, Set<? extends VariableDescriptor>>> getClosureInstructionsWithForeigns() {
        if (CompileStaticUtil.isCompileStatic(this.myScope)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<Instruction, Set<? extends VariableDescriptor>>> closureInstructions = new ArrayList<Pair<Instruction, Set<? extends VariableDescriptor>>>();
        for (Instruction closureInstruction : this.myFlow) {
            GrControlFlowOwner owner;
            PsiElement closure = closureInstruction.getElement();
            if (!(closure instanceof GrFunctionalExpression) || (owner = FunctionalExpressionFlowUtil.getControlFlowOwner((GrFunctionalExpression)closure)) == null) continue;
            Set<ResolvedVariableDescriptor> foreignVariables = ControlFlowUtils.getOverwrittenForeignVariableDescriptors(owner);
            closureInstructions.add((Pair<Instruction, Set<? extends VariableDescriptor>>)Pair.create((Object)closureInstruction, foreignVariables));
        }
        return closureInstructions;
    }

    @NotNull
    private Set<Pair<Instruction, VariableDescriptor>> findDependencies(@NotNull List<DefinitionMap> definitionMaps, @NotNull List<Pair<Instruction, Set<? extends VariableDescriptor>>> closureInstructions, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor) {
        if (definitionMaps == null) {
            InferenceCache.$$$reportNull$$$0(18);
        }
        if (closureInstructions == null) {
            InferenceCache.$$$reportNull$$$0(19);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(20);
        }
        if (descriptor == null) {
            InferenceCache.$$$reportNull$$$0(21);
        }
        DefinitionMap definitionMap = definitionMaps.get(instruction.num());
        int varIndex = ((Object2IntMap)this.myVarIndexes.getValue()).getInt((Object)descriptor);
        int[] definitions = definitionMap.getDefinitions(varIndex);
        LinkedHashSet<Pair<Instruction, VariableDescriptor>> pairs = new LinkedHashSet<Pair<Instruction, VariableDescriptor>>();
        int latestDefinition = Math.max(instruction.num(), definitions == null ? 0 : ArrayUtil.max((int[])definitions));
        for (Pair<Instruction, Set<? extends VariableDescriptor>> closureInstruction : closureInstructions) {
            if (((Instruction)closureInstruction.first).num() > latestDefinition) break;
            if (!((Set)closureInstruction.second).contains(descriptor)) continue;
            pairs.add((Pair<Instruction, VariableDescriptor>)Pair.create((Object)((Instruction)closureInstruction.first), (Object)descriptor));
            if (!(closureInstruction.first instanceof ReadWriteVariableInstruction)) continue;
            pairs.add((Pair<Instruction, VariableDescriptor>)Pair.create((Object)((Instruction)closureInstruction.first), (Object)((ReadWriteVariableInstruction)closureInstruction.first).getDescriptor()));
        }
        if (definitions == null) {
            LinkedHashSet<Pair<Instruction, VariableDescriptor>> linkedHashSet = pairs;
            if (linkedHashSet == null) {
                InferenceCache.$$$reportNull$$$0(22);
            }
            return linkedHashSet;
        }
        for (Object defIndex : (Object)definitions) {
            Instruction write = this.myFlow[defIndex];
            if (write != instruction) {
                pairs.add((Pair<Instruction, VariableDescriptor>)Pair.create((Object)write, (Object)descriptor));
            }
            for (ReadWriteVariableInstruction dependency : UtilKt.findReadDependencies(write, (Function1<? super PsiElement, ? extends Collection<? extends Instruction>>)((Function1)it -> this.myFromByElements.getOrDefault(it, Collections.emptyList())))) {
                pairs.add((Pair<Instruction, VariableDescriptor>)Pair.create((Object)dependency, (Object)dependency.getDescriptor()));
            }
        }
        LinkedHashSet<Pair<Instruction, VariableDescriptor>> linkedHashSet = pairs;
        if (linkedHashSet == null) {
            InferenceCache.$$$reportNull$$$0(23);
        }
        return linkedHashSet;
    }

    private void cacheDfaResult(@NotNull List<TypeDfaState> dfaResult, Set<Instruction> storingInstructions) {
        if (dfaResult == null) {
            InferenceCache.$$$reportNull$$$0(24);
        }
        this.myVarTypes.accumulateAndGet(dfaResult, (oldState, newState) -> InferenceCache.addDfaResult(oldState, newState, storingInstructions));
    }

    @NotNull
    SharedVariableInferenceCache getSharedVariableInferenceCache() {
        SharedVariableInferenceCache sharedVariableInferenceCache = this.mySharedVariableInferenceCache;
        if (sharedVariableInferenceCache == null) {
            InferenceCache.$$$reportNull$$$0(25);
        }
        return sharedVariableInferenceCache;
    }

    @NotNull
    private static List<TypeDfaState> addDfaResult(@NotNull List<TypeDfaState> oldTypes, @NotNull List<TypeDfaState> dfaResult, @NotNull Set<Instruction> storingInstructions) {
        if (oldTypes == null) {
            InferenceCache.$$$reportNull$$$0(26);
        }
        if (dfaResult == null) {
            InferenceCache.$$$reportNull$$$0(27);
        }
        if (storingInstructions == null) {
            InferenceCache.$$$reportNull$$$0(28);
        }
        ArrayList<TypeDfaState> newTypes = new ArrayList<TypeDfaState>(oldTypes);
        Set interestingInstructionNums = storingInstructions.stream().map(Instruction::num).collect(Collectors.toSet());
        for (int i = 0; i < dfaResult.size(); ++i) {
            if (!interestingInstructionNums.contains(i)) continue;
            newTypes.set(i, ((TypeDfaState)newTypes.get(i)).mergeWith(dfaResult.get(i)));
        }
        ArrayList<TypeDfaState> arrayList = newTypes;
        if (arrayList == null) {
            InferenceCache.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private boolean isDescriptorAvailable(@NotNull VariableDescriptor descriptor) {
        if (descriptor == null) {
            InferenceCache.$$$reportNull$$$0(30);
        }
        if (((Object2IntMap)this.myVarIndexes.getValue()).containsKey((Object)descriptor)) {
            return true;
        }
        return ControlFlowUtils.getForeignVariableDescriptors(this.myScope).contains(descriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 16: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialTypes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionMaps";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureInstructions";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/InferenceCache";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaResult";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTypes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storingInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/InferenceCache";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencies";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedVariableInferenceCache";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addDfaResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performTypeDfa";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeInitialState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInferredType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectFlowInfo";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findDependencies";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cacheDfaResult";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addDfaResult";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDescriptorAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

