/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public final class DefinitionMap {
    private final Int2ObjectMap<IntSet> myMap = new Int2ObjectOpenHashMap();

    public void registerDef(int varIndex, Instruction instruction) {
        IntSet defs = (IntSet)this.myMap.get(varIndex);
        if (defs == null) {
            defs = new IntOpenHashSet();
            this.myMap.put(varIndex, (Object)defs);
        } else {
            defs.clear();
        }
        defs.add(instruction.num());
    }

    public void mergeFrom(DefinitionMap other) {
        for (Int2ObjectMap.Entry entry : other.myMap.int2ObjectEntrySet()) {
            int varIndex = entry.getIntKey();
            IntSet otherDefs = (IntSet)entry.getValue();
            IntSet myDefs = (IntSet)this.myMap.get(varIndex);
            if (myDefs == null) {
                myDefs = new IntOpenHashSet((IntCollection)otherDefs);
                this.myMap.put(varIndex, (Object)myDefs);
                continue;
            }
            myDefs.addAll((IntCollection)otherDefs);
        }
    }

    public int @Nullable [] getDefinitions(int varIndex) {
        IntSet defs = (IntSet)this.myMap.get(varIndex);
        return defs == null ? null : defs.toIntArray();
    }

    public void forEachValue(Consumer<IntSet> procedure) {
        this.myMap.values().forEach(procedure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefinitionMap map2 = (DefinitionMap)o;
        return this.myMap.equals(map2.myMap);
    }

    public int hashCode() {
        return Objects.hash(this.myMap);
    }
}

