/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyMembersGetter;
import org.jetbrains.plugins.groovy.lang.completion.handlers.AfterNewClassInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public final class GroovySmartCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> INSIDE_EXPRESSION = PlatformPatterns.psiElement().withParent(GrExpression.class);
    private static final ElementPattern<PsiElement> IN_CAST_PARENTHESES = PlatformPatterns.psiElement().withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement(GrTypeCastExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GrAssignmentExpression.class), PlatformPatterns.psiElement(GrVariable.class)})));
    static final ElementPattern<PsiElement> AFTER_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.kNEW));
    private static final ElementPattern<PsiElement> IN_ANNOTATION = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GrReferenceExpression.class).withParent(GrAnnotationNameValuePair.class));
    private static final Hash.Strategy<TypeConstraint> EXPECTED_TYPE_INFO_STRATEGY = new Hash.Strategy<TypeConstraint>(){

        public int hashCode(@Nullable TypeConstraint object) {
            return object == null ? 0 : object.getType().hashCode();
        }

        public boolean equals(@Nullable TypeConstraint o1, @Nullable TypeConstraint o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.getClass().equals(o2.getClass()) && o1.getType().equals(o2.getType());
        }
    };

    public GroovySmartCompletionContributor() {
        this.extend(CompletionType.SMART, INSIDE_EXPRESSION, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters params, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position;
                if (params == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((position = params.getPosition()).getParent() instanceof GrLiteral) {
                    return;
                }
                if (GroovySmartCompletionContributor.isInDefaultAnnotationNameValuePair(position)) {
                    return;
                }
                Set<TypeConstraint> infos = GroovySmartCompletionContributor.getExpectedTypeInfos(params);
                PsiElement reference = position.getParent();
                if (reference == null) {
                    return;
                }
                if (reference instanceof GrReferenceElement) {
                    GroovyCompletionUtil.processVariants((GrReferenceElement)reference, result2.getPrefixMatcher(), params, (Consumer<LookupElement>)((Consumer)variant -> {
                        PsiType type2 = null;
                        Object o = variant.getObject();
                        if (o instanceof GroovyResolveResult) {
                            if (!((GroovyResolveResult)o).isAccessible()) {
                                return;
                            }
                            o = ((GroovyResolveResult)o).getElement();
                        }
                        if (o instanceof PsiElement) {
                            type2 = GroovySmartCompletionContributor.getTypeByElement((PsiElement)o, position);
                        } else if (o instanceof String && ("true".equals(o) || "false".equals(o))) {
                            type2 = PsiType.BOOLEAN;
                        }
                        if (type2 == null) {
                            return;
                        }
                        for (TypeConstraint info : infos) {
                            if (!info.satisfied(type2, position)) continue;
                            result2.addElement(variant);
                            break;
                        }
                    }));
                }
                GroovySmartCompletionContributor.addExpectedClassMembers(params, result2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "params";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.SMART, IN_CAST_PARENTHESES, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position;
                GrTypeCastExpression parenthesizedExpression;
                PsiElement assignment;
                if (parameters2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((assignment = (parenthesizedExpression = (GrTypeCastExpression)(position = parameters2.getPosition()).getParent().getParent().getParent()).getParent()) instanceof GrAssignmentExpression && ((GrAssignmentExpression)assignment).getLValue() == parenthesizedExpression) {
                    return;
                }
                final boolean overwrite = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("(")).withParent(GrTypeCastExpression.class))).accepts((Object)parameters2.getOriginalPosition());
                Set<TypeConstraint> typeConstraints = GroovySmartCompletionContributor.getExpectedTypeInfos(parameters2);
                for (TypeConstraint typeConstraint : typeConstraints) {
                    PsiType type2 = typeConstraint.getType();
                    PsiTypeLookupItem item = PsiTypeLookupItem.createLookupItem((PsiType)type2, (PsiElement)position, (boolean)PsiTypeLookupItem.isDiamond((PsiType)type2), ChooseTypeExpression.IMPORT_FIXER).setShowPackage();
                    item.setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                            if (context == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (item == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.casting");
                            Editor editor = context.getEditor();
                            Document document = editor.getDocument();
                            if (overwrite) {
                                document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
                            }
                            CommonCodeStyleSettings csSettings = CodeStyle.getLanguageSettings((PsiFile)context.getFile(), (Language)GroovyLanguage.INSTANCE);
                            int oldTail = context.getTailOffset();
                            context.setTailOffset(GroovyCompletionUtil.addRParenth(editor, oldTail, csSettings.SPACE_WITHIN_CAST_PARENTHESES));
                            if (csSettings.SPACE_AFTER_TYPE_CAST) {
                                context.setTailOffset(TailType.insertChar((Editor)editor, (int)context.getTailOffset(), (char)' '));
                            }
                            editor.getCaretModel().moveToOffset(context.getTailOffset());
                            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            GroovyCompletionUtil.addImportForItem(context.getFile(), context.getStartOffset(), item);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "context";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "item";
                                    break;
                                }
                            }
                            objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$3$1";
                            objectArray[2] = "handleInsert";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    result2.addElement((LookupElement)item);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.SMART, AFTER_NEW, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext matchingContext, @NotNull CompletionResultSet result2) {
                if (parameters2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (matchingContext == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                GroovySmartCompletionContributor.generateInheritorVariants(parameters2, result2.getPrefixMatcher(), (Consumer<? super LookupElement>)((Consumer)lookupElement -> result2.addElement(lookupElement)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "matchingContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$4";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.SMART, IN_ANNOTATION, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters params, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position;
                if (params == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (!GroovySmartCompletionContributor.isInDefaultAnnotationNameValuePair(position = params.getPosition())) {
                    return;
                }
                GrReferenceExpression reference = (GrReferenceExpression)position.getParent();
                if (reference == null) {
                    return;
                }
                CompleteReferenceExpression.processRefInAnnotation(reference, result2.getPrefixMatcher(), (Consumer<LookupElement>)((Consumer)element -> {
                    if (element != null) {
                        result2.addElement(element);
                    }
                }), params);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "params";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$5";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isInDefaultAnnotationNameValuePair(PsiElement position) {
        PsiElement resolved;
        PsiElement ppparent;
        PsiElement identifier;
        PsiElement pparent;
        PsiElement parent2 = position.getParent();
        if (parent2 instanceof GrReferenceExpression && (pparent = parent2.getParent()) instanceof GrAnnotationNameValuePair && (identifier = ((GrAnnotationNameValuePair)pparent).getNameIdentifierGroovy()) == null && (ppparent = pparent.getParent().getParent()) instanceof GrAnnotation && (resolved = ((GrAnnotation)ppparent).getClassReference().resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            PsiMethod[] values = ((PsiClass)resolved).findMethodsByName("value", false);
            return values.length == 0;
        }
        return false;
    }

    static void addExpectedClassMembers(CompletionParameters params, CompletionResultSet result2) {
        for (TypeConstraint info : GroovySmartCompletionContributor.getExpectedTypeInfos(params)) {
            boolean searchInheritors;
            Consumer consumer = element -> result2.addElement(element);
            PsiType type2 = info.getType();
            PsiType defType = info.getDefaultType();
            boolean bl = searchInheritors = params.getInvocationCount() > 1;
            if (type2 instanceof PsiClassType) {
                new GroovyMembersGetter((PsiClassType)type2, params).processMembers(searchInheritors, (Consumer<LookupElement>)consumer);
            }
            if (defType.equals(type2) || !(defType instanceof PsiClassType)) continue;
            new GroovyMembersGetter((PsiClassType)defType, params).processMembers(searchInheritors, (Consumer<LookupElement>)consumer);
        }
    }

    static void generateInheritorVariants(CompletionParameters parameters2, PrefixMatcher matcher, Consumer<? super LookupElement> consumer) {
        PsiElement place = parameters2.getPosition();
        GrExpression expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)place, GrExpression.class);
        if (expression == null) {
            return;
        }
        GrExpression placeToInferType = expression;
        if (expression.getParent() instanceof GrApplicationStatement && expression.getParent().getParent() instanceof GrAssignmentExpression) {
            placeToInferType = (GrExpression)expression.getParent();
        }
        for (PsiType psiType : GroovyExpectedTypesProvider.getDefaultExpectedTypes(placeToInferType)) {
            if (!(psiType instanceof PsiArrayType)) continue;
            PsiType _type = GenericsUtil.eliminateWildcards((PsiType)psiType);
            PsiTypeLookupItem item = PsiTypeLookupItem.createLookupItem((PsiType)_type, (PsiElement)place, (boolean)PsiTypeLookupItem.isDiamond((PsiType)_type), ChooseTypeExpression.IMPORT_FIXER).setShowPackage();
            if (item.getObject() instanceof PsiClass) {
                item.setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        if (context == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            6.$$$reportNull$$$0(1);
                        }
                        GroovyCompletionUtil.addImportForItem(context.getFile(), context.getStartOffset(), item);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$6";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            consumer.consume((Object)item);
        }
        SmartList expectedClassTypes = new SmartList();
        for (PsiType psiType : GroovyExpectedTypesProvider.getDefaultExpectedTypes(placeToInferType)) {
            PsiType type4;
            PsiClassType classType;
            if (!(psiType instanceof PsiClassType) || (classType = (PsiClassType)(type4 = GenericsUtil.eliminateWildcards((PsiType)JavaCompletionUtil.originalize((PsiType)psiType)))).resolve() == null) continue;
            expectedClassTypes.add(classType);
        }
        PsiType psiType = GroovySmartCompletionContributor.inferDiamond(place);
        JavaInheritorsGetter.processInheritors((CompletionParameters)parameters2, (Collection)expectedClassTypes, (PrefixMatcher)matcher, type2 -> {
            LookupElement element = GroovySmartCompletionContributor.addExpectedType(type2, place, parameters2, diamond);
            if (element != null) {
                consumer.consume((Object)element);
            }
        });
    }

    @Nullable
    private static PsiType inferDiamond(PsiElement place) {
        PsiElement ppparent;
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(place, "1.8")) {
            return null;
        }
        PsiElement parent2 = place.getParent().getParent();
        if (!(parent2 instanceof GrNewExpression)) {
            return null;
        }
        PsiElement pparent = parent2.getParent();
        if (pparent instanceof GrVariable) {
            return ((GrVariable)pparent).getDeclaredType();
        }
        if (pparent instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)pparent;
            GrExpression lvalue = assignment.getLValue();
            GrExpression rvalue = assignment.getRValue();
            if (parent2 == rvalue && !assignment.isOperatorAssignment()) {
                return lvalue.getNominalType();
            }
        } else if (pparent instanceof GrApplicationStatement && (ppparent = pparent.getParent()) instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)ppparent;
            GrExpression lvalue = assignment.getLValue();
            GrExpression rvalue = assignment.getRValue();
            if (pparent == rvalue && !assignment.isOperatorAssignment()) {
                return lvalue.getNominalType();
            }
        }
        return null;
    }

    @Nullable
    private static LookupElement addExpectedType(PsiType type2, PsiElement place, CompletionParameters parameters2, @Nullable PsiType diamond) {
        PsiTypeLookupItem item;
        Object object;
        if (!JavaCompletionUtil.hasAccessibleConstructor((PsiType)type2, (PsiElement)place)) {
            return null;
        }
        PsiClass psiClass = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null) {
            return null;
        }
        if (!GroovySmartCompletionContributor.checkForInnerClass(psiClass, place)) {
            return null;
        }
        boolean isDiamond = false;
        if (diamond != null && psiClass.hasTypeParameters() && !((PsiClassType)type2).isRaw() && !psiClass.hasModifierProperty("abstract")) {
            String canonicalText = TypeConversionUtil.erasure((PsiType)type2).getCanonicalText();
            GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(place.getProject());
            String text = diamond.getCanonicalText() + " v = new " + canonicalText + "<>()";
            GrStatement statement = elementFactory.createStatementFromText(text, (PsiElement)parameters2.getOriginalFile());
            GrVariable declaredVar = ((GrVariableDeclaration)statement).getVariables()[0];
            GrNewExpression initializer = (GrNewExpression)declaredVar.getInitializerGroovy();
            assert (initializer != null);
            boolean hasDefaultConstructorOrNoGenericsOne = PsiDiamondTypeImpl.hasDefaultConstructor((PsiClass)psiClass) || !PsiDiamondTypeImpl.haveConstructorsGenericsParameters((PsiClass)psiClass);
            PsiType initializerType = initializer.getType();
            if (hasDefaultConstructorOrNoGenericsOne && initializerType instanceof PsiClassType && ((PsiClassType)initializerType).getParameters().length > 0) {
                type2 = initializerType;
                isDiamond = true;
            }
        }
        if ((object = (item = PsiTypeLookupItem.createLookupItem((PsiType)GenericsUtil.eliminateWildcards((PsiType)type2), (PsiElement)place, (boolean)isDiamond, ChooseTypeExpression.IMPORT_FIXER).setShowPackage()).getObject()) instanceof PsiClass && ((PsiClass)object).hasModifierProperty("abstract")) {
            item.setIndicateAnonymous(true);
        }
        item.setInsertHandler((InsertHandler)new AfterNewClassInsertHandler((PsiClassType)type2, true));
        return item;
    }

    private static boolean checkForInnerClass(PsiClass psiClass, PsiElement identifierCopy) {
        return !com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)psiClass) || PsiUtil.hasEnclosingInstanceInScope(psiClass.getContainingClass(), identifierCopy, true);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            GroovySmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if (context.getCompletionType() != CompletionType.SMART) {
            return;
        }
        PsiElement lastElement = context.getFile().findElementAt(context.getStartOffset() - 1);
        if (lastElement != null && lastElement.getText().equals("(")) {
            PsiElement parent2 = lastElement.getParent();
            if (parent2 instanceof GrTypeCastExpression) {
                context.setDummyIdentifier("");
            } else if (parent2 instanceof GrParenthesizedExpression) {
                context.setDummyIdentifier("xxx)yyy ");
            }
        }
    }

    private static Set<TypeConstraint> getExpectedTypeInfos(CompletionParameters params) {
        return new ObjectOpenCustomHashSet((Object[])GroovySmartCompletionContributor.getExpectedTypes(params), EXPECTED_TYPE_INFO_STRATEGY);
    }

    public static TypeConstraint @NotNull [] getExpectedTypes(CompletionParameters params) {
        PsiElement position = params.getPosition();
        GrExpression expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)position, GrExpression.class);
        if (expression != null) {
            TypeConstraint[] typeConstraintArray = GroovyExpectedTypesProvider.calculateTypeConstraints(expression);
            if (typeConstraintArray == null) {
                GroovySmartCompletionContributor.$$$reportNull$$$0(1);
            }
            return typeConstraintArray;
        }
        if (TypeConstraint.EMPTY_ARRAY == null) {
            GroovySmartCompletionContributor.$$$reportNull$$$0(2);
        }
        return TypeConstraint.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiType getTypeByElement(PsiElement element, PsiElement context) {
        if (element instanceof PsiType) {
            return (PsiType)element;
        }
        if (element instanceof PsiClass) {
            return PsiType.getJavaLangClass((PsiManager)context.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject()));
        }
        if (element instanceof PsiMethod) {
            return PsiUtil.getSmartReturnType((PsiMethod)element);
        }
        if (element instanceof GrVariable) {
            return TypeInferenceHelper.getVariableTypeInContext(context, (GrVariable)element);
        }
        if (element instanceof GrExpression) {
            return ((GrExpression)element).getType();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getType();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

