/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.style.inference.CollectingGroovyInferenceSession;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.MethodInstantiationUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.NameGenerator;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceEnvironment;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptions;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.CommonDriver;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.EmptyDriver;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriver;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.ParameterizationManager;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.TypeUsageInformation;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceGraphUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitGraph;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitGraphKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"forbiddenAnnotations", "", "", "createDriver", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/InferenceDriver;", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "environment", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceEnvironment;", "runInferenceProcess", "options", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceOptions;", "setUpGraph", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraph;", "virtualMethod", "constantTypes", "", "Lcom/intellij/psi/PsiTypeParameter;", "typeUsage", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformation;", "eligibleForExtendedInference", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;", "intellij.groovy"})
public final class InferenceProcessKt {
    private static final Set<String> forbiddenAnnotations = SetsKt.setOf((Object[])new String[]{"groovy.lang.DelegatesTo", "groovy.transform.stc.ClosureParams"});

    @NotNull
    public static final GrMethod runInferenceProcess(@NotNull GrMethod method, @NotNull SignatureInferenceOptions options2) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        GrMethod originalMethod = InferenceProcessUtilKt.getOriginalMethod(method);
        PsiMethod overridableMethod = InferenceProcessUtilKt.findOverridableMethod(originalMethod);
        if (overridableMethod != null) {
            GrMethod grMethod = InferenceProcessUtilKt.convertToGroovyMethod(overridableMethod);
            if (grMethod == null) {
                grMethod = method;
            }
            return grMethod;
        }
        SearchScope searchScope = InferenceProcessUtilKt.getSearchScope(method, options2.getShouldUseReducedScope());
        if (searchScope == null) {
            return method;
        }
        SearchScope searchScope2 = searchScope;
        SignatureInferenceEnvironment environment = new SignatureInferenceEnvironment(originalMethod, searchScope2, options2.getSignatureInferenceContext(), false, 8, null);
        InferenceDriver driver = InferenceProcessKt.createDriver(originalMethod, environment);
        PsiSubstitutor signatureSubstitutor = InferenceProcessUtilKt.removeForeignTypeParameters(driver.collectSignatureSubstitutor(), method);
        SmartPsiElementPointer smartPsiElementPointer = InferenceProcessUtilKt.createVirtualMethod$default(method, null, false, 6, null);
        if (smartPsiElementPointer == null) {
            return method;
        }
        SmartPsiElementPointer virtualMethodPointer = smartPsiElementPointer;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        GrMethod grMethod = (GrMethod)virtualMethodPointer.getElement();
        if (grMethod == null) {
            return method;
        }
        Intrinsics.checkNotNullExpressionValue((Object)grMethod, (String)"virtualMethodPointer.element ?: return method");
        GrMethod virtualMethod = grMethod;
        InferenceDriver parameterizedDriver = driver.createParameterizedDriver(new ParameterizationManager(method), virtualMethod, signatureSubstitutor);
        TypeUsageInformation typeUsage = parameterizedDriver.collectInnerConstraints();
        bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        GrMethod grMethod2 = (GrMethod)virtualMethodPointer.getElement();
        if (grMethod2 == null) {
            return method;
        }
        Intrinsics.checkNotNullExpressionValue((Object)grMethod2, (String)"virtualMethodPointer.element ?: return method");
        GrMethod virtualMethod2 = grMethod2;
        Object[] objectArray = method.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"method.typeParameters");
        InferenceUnitGraph graph = InferenceProcessKt.setUpGraph(virtualMethod2, ArraysKt.asList((Object[])objectArray), typeUsage);
        InferenceUnitGraph inferredGraph = InferenceUnitGraphKt.determineDependencies(graph);
        return MethodInstantiationUtilKt.instantiateTypeParameters(parameterizedDriver, inferredGraph, method, typeUsage);
    }

    public static final boolean eligibleForExtendedInference(@NotNull GrParameter $this$eligibleForExtendedInference) {
        Intrinsics.checkNotNullParameter((Object)$this$eligibleForExtendedInference, (String)"$this$eligibleForExtendedInference");
        return $this$eligibleForExtendedInference.getTypeElement() == null;
    }

    private static final InferenceDriver createDriver(GrMethod method, SignatureInferenceEnvironment environment) {
        SmartPsiElementPointer smartPsiElementPointer = InferenceProcessUtilKt.createVirtualMethod$default(method, null, false, 6, null);
        if (smartPsiElementPointer == null) {
            return EmptyDriver.INSTANCE;
        }
        SmartPsiElementPointer virtualMethodPointer = smartPsiElementPointer;
        NameGenerator generator = new NameGenerator("_START" + method.hashCode(), method);
        return CommonDriver.Companion.createFromMethod(method, (SmartPsiElementPointer<GrMethod>)virtualMethodPointer, generator, environment);
    }

    private static final InferenceUnitGraph setUpGraph(GrMethod virtualMethod, List<? extends PsiTypeParameter> constantTypes, TypeUsageInformation typeUsage) {
        PsiTypeParameter[] psiTypeParameterArray = virtualMethod.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"virtualMethod.typeParameters");
        CollectingGroovyInferenceSession inferenceSession = new CollectingGroovyInferenceSession(psiTypeParameterArray, virtualMethod, null, null, null, false, null, 0, 252, null);
        typeUsage.fillSession(inferenceSession);
        inferenceSession.infer();
        return InferenceGraphUtilKt.createGraphFromInferenceVariables(inferenceSession, virtualMethod, typeUsage, constantTypes);
    }
}

