/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.findUsages.GroovyWordsScanner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.refactoring.rename.PropertyForRename;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider;", "Lcom/intellij/lang/findUsages/FindUsagesProvider;", "()V", "canFindUsagesFor", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getDescriptiveName", "", "element", "getHelpId", "getNodeText", "useFullName", "getType", "getWordsScanner", "Lcom/intellij/lang/cacheBuilder/WordsScanner;", "intellij.groovy.psi"})
public class GroovyFindUsagesProvider
implements FindUsagesProvider {
    @Nullable
    public WordsScanner getWordsScanner() {
        return (WordsScanner)new GroovyWordsScanner();
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return psiElement instanceof PsiClass || psiElement instanceof PsiMethod || psiElement instanceof GrVariable;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof GrTraitTypeDefinition) {
            String string2 = GroovyBundle.message("groovy.term.trait", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"groovy.term.trait\")");
        } else if (psiElement instanceof GrInterfaceDefinition) {
            String string3 = GroovyBundle.message("groovy.term.interface", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"groovy.term.interface\")");
        } else if (psiElement instanceof GrAnnotationTypeDefinition) {
            String string4 = GroovyBundle.message("groovy.term.annotation", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"groovy.term.annotation\")");
        } else if (psiElement instanceof GrEnumTypeDefinition) {
            String string5 = GroovyBundle.message("groovy.term.enum", new Object[0]);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"groovy.term.enum\")");
        } else if (psiElement instanceof GrClassDefinition) {
            String string6 = GroovyBundle.message("groovy.term.class", new Object[0]);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"groovy.term.class\")");
        } else if (psiElement instanceof GrMethod) {
            String string7 = GroovyBundle.message("groovy.term.method", new Object[0]);
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(\"groovy.term.method\")");
        } else if (psiElement instanceof GrField) {
            String string8 = ((GrField)element).isProperty() ? GroovyBundle.message("groovy.term.property", new Object[0]) : GroovyBundle.message("groovy.term.field", new Object[0]);
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"if (element.isProperty) \u2026sage(\"groovy.term.field\")");
        } else if (psiElement instanceof GrParameter) {
            String string9 = GroovyBundle.message("groovy.term.parameter", new Object[0]);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(\"groovy.term.parameter\")");
        } else if (psiElement instanceof GrBindingVariable) {
            String string10 = GroovyBundle.message("groovy.term.binding", new Object[0]);
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(\"groovy.term.binding\")");
        } else if (psiElement instanceof GrVariable) {
            String string11 = GroovyBundle.message("groovy.term.variable", new Object[0]);
            string = string11;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(\"groovy.term.variable\")");
        } else if (psiElement instanceof GrLabeledStatement) {
            String string12 = GroovyBundle.message("groovy.term.label", new Object[0]);
            string = string12;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"message(\"groovy.term.label\")");
        } else if (psiElement instanceof GrClosableBlock) {
            String string13 = GroovyBundle.message("groovy.term.closure", new Object[0]);
            string = string13;
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"message(\"groovy.term.closure\")");
        } else if (psiElement instanceof GrExpression) {
            String string14 = GroovyBundle.message("groovy.term.expression", new Object[0]);
            string = string14;
            Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"message(\"groovy.term.expression\")");
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        String descriptiveName;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof PsiClass) {
            string2 = ((PsiClass)element).getQualifiedName();
        } else if (psiElement instanceof PsiMethod) {
            String method = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            PsiClass clazz = ((PsiMethod)element).getContainingClass();
            string2 = clazz == null ? method : GroovyBundle.message("find.usages.method.0.of.class.1", method, this.getDescriptiveName((PsiElement)clazz));
        } else {
            string2 = psiElement instanceof PsiVariable ? ((PsiVariable)element).getName() : (psiElement instanceof GrLabeledStatement ? ((GrLabeledStatement)element).getName() : (psiElement instanceof PropertyForRename ? ((PropertyForRename)element).getPropertyName() : (psiElement instanceof GrLiteral ? ((GrLiteral)element).getText() : null)));
        }
        if ((string = (descriptiveName = string2)) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        String nodeText;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof PsiClass) {
            if (useFullName) {
                string2 = ((PsiClass)element).getQualifiedName();
                if (string2 == null) {
                    string2 = ((PsiClass)element).getName();
                }
            } else {
                string2 = ((PsiClass)element).getName();
            }
        } else {
            string2 = psiElement instanceof PsiMethod ? PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2) : (psiElement instanceof PsiVariable ? ((PsiVariable)element).getName() : null);
        }
        if ((string = (nodeText = string2)) == null) {
            string = "";
        }
        return string;
    }
}

