/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import groovy.lang.Closure;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.DslErrorReporter;
import org.jetbrains.plugins.groovy.dsl.FactorTree;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslExecutor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;

public class GroovyDslScript {
    private static final Logger LOG = Logger.getInstance(GroovyDslScript.class);
    private final Project project;
    @Nullable
    private final VirtualFile file;
    private final GroovyDslExecutor executor;
    private final String myPath;
    private final FactorTree myFactorTree;

    public GroovyDslScript(Project project, @Nullable VirtualFile file, @NotNull GroovyDslExecutor executor, String path) {
        if (executor == null) {
            GroovyDslScript.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.file = file;
        this.executor = executor;
        this.myPath = path;
        this.myFactorTree = new FactorTree(project, executor);
    }

    @NotNull
    public CustomMembersHolder processExecutor(@NotNull GroovyClassDescriptor descriptor) {
        CustomMembersHolder customMembersHolder;
        if (descriptor == null) {
            GroovyDslScript.$$$reportNull$$$0(1);
        }
        CustomMembersHolder holder = this.myFactorTree.retrieve(descriptor);
        try {
            if (holder == null) {
                holder = this.addGdslMembers(descriptor);
                this.myFactorTree.cache(descriptor, holder);
            }
            customMembersHolder = holder;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            this.handleDslError(e);
            CustomMembersHolder customMembersHolder2 = CustomMembersHolder.EMPTY;
            if (customMembersHolder2 == null) {
                GroovyDslScript.$$$reportNull$$$0(3);
            }
            return customMembersHolder2;
        }
        if (customMembersHolder == null) {
            GroovyDslScript.$$$reportNull$$$0(2);
        }
        return customMembersHolder;
    }

    private CustomMembersHolder addGdslMembers(@NotNull GroovyClassDescriptor descriptor) {
        if (descriptor == null) {
            GroovyDslScript.$$$reportNull$$$0(4);
        }
        ProcessingContext ctx = new ProcessingContext();
        ctx.put(GdslUtil.INITIAL_CONTEXT, (Object)descriptor);
        try {
            if (!GroovyDslScript.isApplicable(this.executor, descriptor, ctx)) {
                return CustomMembersHolder.EMPTY;
            }
            return this.executor.processVariants(descriptor, ctx);
        }
        catch (InvokerInvocationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)cause;
            }
            if (cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            this.handleDslError(e);
        }
        catch (ProcessCanceledException | OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            this.handleDslError(e);
        }
        return CustomMembersHolder.EMPTY;
    }

    private static boolean isApplicable(@NotNull GroovyDslExecutor executor, GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        List<Pair<ContextFilter, Closure>> enhancers;
        if (executor == null) {
            GroovyDslScript.$$$reportNull$$$0(5);
        }
        if ((enhancers = executor.getEnhancers()) == null) {
            LOG.error("null enhancers");
            return false;
        }
        for (Pair<ContextFilter, Closure> pair : enhancers) {
            if (!((ContextFilter)pair.first).isApplicable(descriptor, ctx)) continue;
            return true;
        }
        return false;
    }

    public void handleDslError(Throwable e) {
        if (this.project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(e);
        }
        if (this.file != null) {
            DslErrorReporter.getInstance().invokeDslErrorPopup(e, this.project, this.file);
        } else {
            LOG.info("Error when executing internal GDSL " + this.myPath, e);
            GdslUtil.stopGdsl();
        }
    }

    @NonNls
    public String toString() {
        return "GroovyDslScript: " + this.myPath;
    }

    @NotNull
    public MultiMap getStaticInfo() {
        MultiMap multiMap = this.executor.getStaticInfo();
        if (multiMap == null) {
            GroovyDslScript.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/dsl/GroovyDslScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/dsl/GroovyDslScript";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processExecutor";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addGdslMembers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

