/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessChecker;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.ReferenceFixesKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"checkUnresolvedReference", "", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "highlightIfGroovyObjectOverridden", "", "highlightIfMissingMethodsDeclared", "highlightSink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "getBestResolveResults", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "results", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyReference;", "intellij.groovy.psi"})
@JvmName(name="GroovyUnresolvedAccessChecker")
public final class GroovyUnresolvedAccessChecker {
    public static final void checkUnresolvedReference(@NotNull GrReferenceExpression expression, boolean highlightIfGroovyObjectOverridden, boolean highlightIfMissingMethodsDeclared, @NotNull HighlightSink highlightSink) {
        boolean bl;
        Object object;
        Collection $this$all$iv2;
        Collection<GroovyResolveResult> results;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)highlightSink, (String)"highlightSink");
        PsiElement psiElement = expression.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.referenceNameElement ?: return");
        PsiElement referenceNameElement = psiElement;
        String string = expression.getReferenceName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.referenceName ?: return");
        String referenceName = string;
        PsiElement parent2 = expression.getParent();
        Collection<GroovyResolveResult> collection = results = GroovyUnresolvedAccessChecker.getBestResolveResults(expression);
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            boolean staticsOk2;
            block13: {
                boolean bl3;
                Iterable $this$all$iv2 = results;
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        GroovyResolveResult p1 = (GroovyResolveResult)element$iv;
                        boolean bl4 = false;
                        if (GrUnresolvedAccessChecker.isStaticOk(p1)) continue;
                        bl3 = false;
                        break block13;
                    }
                    bl3 = staticsOk2 = true;
                }
            }
            if (!staticsOk2) {
                highlightSink.registerProblem(referenceNameElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, GroovyBundle.message("cannot.reference.non.static", referenceName), new LocalQuickFix[0]);
            }
            return;
        }
        if (ResolveUtil.isKeyOfMap(expression) || ResolveUtil.isClassReference(expression)) {
            return;
        }
        if (!highlightIfGroovyObjectOverridden && GrUnresolvedAccessChecker.areGroovyObjectMethodsOverridden(expression)) {
            return;
        }
        if (!highlightIfMissingMethodsDeclared && GrUnresolvedAccessChecker.areMissingMethodsDeclared(expression)) {
            return;
        }
        ArrayList actions = new ArrayList();
        if (parent2 instanceof GrMethodCall) {
            $this$all$iv2 = actions;
            object = GroovyQuickFixFactory.getInstance().createGroovyStaticImportMethodFix((GrMethodCall)parent2);
            bl = false;
            $this$all$iv2.add(object);
            if (PsiUtil.isNewified(expression)) {
                $this$all$iv2 = actions;
                object = ReferenceFixesKt.generateAddImportActions(expression);
                bl = false;
                CollectionsKt.addAll((Collection)$this$all$iv2, (Iterable)object);
            }
        } else {
            $this$all$iv2 = actions;
            object = ReferenceFixesKt.generateCreateClassActions(expression);
            bl = false;
            CollectionsKt.addAll((Collection)$this$all$iv2, (Iterable)object);
            $this$all$iv2 = actions;
            object = ReferenceFixesKt.generateAddImportActions(expression);
            bl = false;
            CollectionsKt.addAll((Collection)$this$all$iv2, (Iterable)object);
        }
        $this$all$iv2 = actions;
        object = ReferenceFixesKt.generateReferenceExpressionFixes(expression);
        bl = false;
        CollectionsKt.addAll((Collection)$this$all$iv2, (Iterable)object);
        QuickFixActionRegistrar registrar2 = new QuickFixActionRegistrar(actions){
            final /* synthetic */ ArrayList $actions;

            public void register(@NotNull IntentionAction action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Collection collection = this.$actions;
                boolean bl = false;
                collection.add(action);
            }

            public void register(@NotNull TextRange fixRange, @NotNull IntentionAction action, @Nullable HighlightDisplayKey key) {
                Intrinsics.checkNotNullParameter((Object)fixRange, (String)"fixRange");
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Collection collection = this.$actions;
                boolean bl = false;
                collection.add(action);
            }
            {
                this.$actions = $captured_local_variable$0;
            }
        };
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)((PsiReference)expression), (QuickFixActionRegistrar)registrar2);
        QuickFixFactory.getInstance().registerOrderEntryFixes(registrar2, (PsiReference)expression);
        highlightSink.registerProblem(referenceNameElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, GroovyBundle.message("cannot.resolve", referenceName), actions);
    }

    private static final Collection<GroovyResolveResult> getBestResolveResults(GroovyReference ref) {
        Collection<? extends GroovyResolveResult> collection = ref.resolve(false);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"ref.resolve(false)");
        return GroovyUnresolvedAccessChecker.getBestResolveResults(collection);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<GroovyResolveResult> getBestResolveResults(Collection<? extends GroovyResolveResult> results) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = results;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            GroovyResolveResult p1 = (GroovyResolveResult)element$iv$iv;
            boolean bl = false;
            if (!p1.isStaticsOK()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection staticsOk2 = (List)destination$iv$iv;
        if (staticsOk2.isEmpty()) {
            return results;
        }
        Iterable $this$filter$iv2 = staticsOk2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GroovyResolveResult p1 = (GroovyResolveResult)element$iv$iv;
            boolean bl = false;
            if (!p1.isAccessible()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Collection accessibleStaticsOk = (List)destination$iv$iv2;
        if (accessibleStaticsOk.isEmpty()) {
            return staticsOk2;
        }
        return accessibleStaticsOk;
    }
}

